/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import static org.junit.Assert.*;

import net.fckeditor.FileType;

import org.junit.Test;

/**
 * Tests for {@link FileTypeHandler}.
 *
 * @version $Id: FileTypeHandlerTest.java 1455 2008-02-01 19:59:38Z th-schwarz $
 */
public class FileTypeHandlerTest {

	
	@Test
    public void getType01() throws Exception {
	    assertTrue(FileTypeHandler.getType("xyz") == null);
    }

	@Test
    public void getType02() throws Exception {
	    assertTrue(FileTypeHandler.getType("file") == FileType.FILE);
    }

	@Test
    public void getType03() throws Exception {
	    assertTrue(FileTypeHandler.getType("FiLe") == FileType.FILE);
    }
	
	@Test
    public void getType04() throws Exception {
	    assertTrue(FileTypeHandler.getType("IMAGE") == FileType.IMAGE);
    }
	
	@Test
    public void isValid01() throws Exception {
	    assertFalse(FileTypeHandler.isValid("1234"));
    }
	
	@Test
    public void isValid02() throws Exception {
	    assertTrue(FileTypeHandler.isValid("fLash"));
    }

	@Test
    public void isValid03() throws Exception {
	    assertTrue(FileTypeHandler.isValid("MeDiA"));
    }
	
	@Test
    public void getTypeDefault01() throws Exception {
	    assertTrue(FileTypeHandler.getTypeDefault("wrong-type").equals(FileType.FILE));
    }

	@Test
    public void getTypeDefault02() throws Exception {
	    assertTrue(FileTypeHandler.getTypeDefault("flAsh").equals(FileType.FLASH));
    }
	
	@Test
    public void getSubDirForType01() throws Exception {
	    assertTrue(FileTypeHandler.getSubDirForType(null).equals("/file"));
    }

	@Test
    public void getSubDirForType02() throws Exception {
	    assertTrue(FileTypeHandler.getSubDirForType(FileType.FILE).equals("/file"));
    }
}
