/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import net.fckeditor.handlers.ConfigurationHandler;

/**
 * Interface to provide session based functionality to FCKeditor.Java. Currently, the implemeted
 * class has to implement the following:
 * <ul>
 * <li>{@link #isAuthenticate(HttpServletRequest)}: User authentication based on
 * {@link HttpServletRequest}, so you can use {@link HttpSession} to identify an user for example.</li>
 * <li>{@link #getBaseDir(HttpServletRequest)}: Constructs an user based 'BaseDir'.</li>
 * </ul>
 * <br />
 * <b>Warning for commiters: </b>You have to awake that every change of this interface could break
 * all classes which implemented this interface. Therfore you should change this interface for
 * milestone releases only!
 * 
 * @version $Id: ISessionData.java 1461 2008-02-03 11:17:31Z th-schwarz $
 */
public interface ISessionData {

	/**
	 * Authenticates the current user.<br>
	 * If the implemantation doesn't bother you, just return <code>true</code>.
	 * 
	 * @param servletRequest
	 * @return
	 */
	public boolean isAuthenticate(final HttpServletRequest servletRequest);

	/**
	 * Getter for the user dependent 'BaseDir'.<br>
	 * <b>Important:</b>
	 * <ul>
	 * <li> If the implementation returns <code>null</code>, {@link ConfigurationHandler} will
	 * used the default one! That's usefull, if the implementation doesn't bother you.</li>
	 * <li>The returned directory string has to start with '/', but has to end without '/'.</li>
	 * </ul>
	 * 
	 * @param servletRequest
	 * @return <code>null</null> or the 'BaseDir' string for the current user.
	 */
	public String getBaseDir(final HttpServletRequest servletRequest);
}
