package net.fckeditor.tags;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class ConfigTag extends TagSupport implements DynamicAttributes {

	private Map<String, String> params = new HashMap<String, String>();
	
	private static final long serialVersionUID = -5282810094404700422L;

	@Override
	public int doStartTag() throws JspException {

		Tag ancestor = findAncestorWithClass(this, EditorTag.class);
		if (ancestor == null)
			throw new JspException(
					"the config tag can only be nested within an editor tag");
		EditorTag editorTag = (EditorTag) ancestor;
		editorTag.setConfigParamAll(params);
		
		return SKIP_BODY;
	}

	public void setDynamicAttribute(String arg0, String arg1, Object arg2)
			throws JspException {
		if (arg2 != null)
			params.put(arg1, arg2.toString());
	}

}
