/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */

package net.fckeditor.tags;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import net.fckeditor.FCKeditor;

/**
 * FCKeditor Tag class to access the
 * {@linkplain net.fckeditor.FCKeditor container}.<br>
 * <p>
 * <b>Simple usage</b>:
 * 
 * <pre>
 * &lt;FCK:editor
 * 	instanceName=&quot;EditorAccessibility&quot;
 * 	width=&quot;80%&quot;
 * 	height=&quot;120&quot;
 * 	toolbarSet=&quot;Accessibility&quot;
 * &quot;&gt;This is another test. &lt;BR&gt;&lt;BR&gt;The &quot;Second&quot; row.&lt;/BR&gt;&lt;/FCK:editor&quot;&gt;
 * </pre>
 * 
 * <p>
 * In this example we set all the attribute for the fckedit tag.
 * 
 * <p>
 * <b>Advanced usage of the tag</b>:
 * 
 * <pre>
 * &lt;FCK:editor instanceName=&quot;EditorDefault&quot; basePath=&quot;/FCKeditor/&quot;
 * 	styleNames=&quot;;Style 1;Style 2; Style 3&quot; 
 * 	fontNames=&quot;;Arial;Courier New;Times New Roman;Verdana&quot; &gt;
 * 	This is some &lt;B&gt;sample text&lt;/B&gt;.
 * &lt;/FCK:editor&gt;
 * </pre>
 * 
 * In this example we set the id and the basePath of the editor (since it is
 * /FCKeditor/ we could have omitted it because it's already the default value).<br>
 * Then we used the the optional attributes to set some advanced configuration
 * settings.
 */
public class EditorTag extends TagSupport {

	private static final long serialVersionUID = -173091731589866140L;

	private String instanceName;
	private String width;
	private String height;
	private String toolbarSet;
	private String basePath;

	/**
	 * The underlying FCKeditor object
	 * 
	 */
	private FCKeditor fckEditor;

	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	/**
	 * Set the width of the textarea
	 * 
	 * @param value
	 *            width
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * Set the height of the textarea
	 * 
	 * @param value
	 *            height
	 */
	public void setHeight(String height) {
		this.height = height;
	}

	/**
	 * Set the name of the toolbar to display
	 * 
	 * @param value
	 *            toolbar name
	 */
	public void setToolbarSet(String toolbarSet) {
		this.toolbarSet = toolbarSet;
	}

	void setValue(String value) {
		fckEditor.setValue(value);
	}
	
	/**
	 * Set the dir where the FCKeditor files reside on the server
	 * 
	 * @param value
	 *            path
	 */
	public void setBasePath(String basePath) {
		this.basePath = basePath;
	}
	
	void setConfigParamAll(Map<String, String> map) {
		fckEditor.getConfig().putAll(map);
	}

	/**
	 * Initialize the FCKeditor container and set attributes
	 * 
	 * @return EVAL_BODY_BUFFERED
	 */
	public int doStartTag() throws JspException {
		fckEditor = new FCKeditor(
				(HttpServletRequest) pageContext.getRequest(), instanceName,
				width, height, toolbarSet, basePath);

		return EVAL_BODY_INCLUDE;
	}
	
	@Override
	public int doEndTag() throws JspException {
		
		JspWriter out = pageContext.getOut();
		
		try {
			out.println(fckEditor);
		} catch (IOException ioe) {
			throw new JspException(
					"Error: IOException while writing to the user");
		}
		
		
		return EVAL_PAGE;
	}

}