/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor;

/**
 * The different types of files to work with.
 * 
 * @version $Id: ResourceType.java 1509 2008-02-13 22:08:27Z mosipov $
 */
public enum ResourceType {

	Image, File, Flash, Media;

	public String getPath() {
		return "/" + name().toLowerCase();
	}

	public static ResourceType getDefaultResourceType(String name) {

		ResourceType rt = getResourceType(name);

		return rt == null ? File : rt;

	}

	public static ResourceType getResourceType(String name) {

		try {
			return ResourceType.valueOf(name);
		} catch (IllegalArgumentException e) {
			return null;
		} catch (NullPointerException e) {
			return null;
		}
	}

	public static boolean isValid(final String name) {
		return getResourceType(name) == null ? false : true;
	}

}
