/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor;

import static org.junit.Assert.*;
import org.junit.Test;

/**
 * Tests for {@link ResourceType}.
 * 
 * @version $Id: ResourceTypeTest.java 1532 2008-02-15 22:59:26Z mosipov $
 */
public class ResourceTypeTest {

	@Test
	public void getType01() throws Exception {
		assertNull(ResourceType.getResourceType("xyz"));
	}

	@Test
	public void getType02() throws Exception {
		assertEquals(ResourceType.FILE, ResourceType.getResourceType("File"));
	}

	@Test
	public void getType03() throws Exception {
		assertEquals(ResourceType.IMAGE, ResourceType.getResourceType("Image"));
	}

	@Test
	public void isValid01() throws Exception {
		assertFalse(ResourceType.isValid("1234"));
	}

	@Test
	public void isValid02() throws Exception {
		assertFalse(ResourceType.isValid("fLash"));
	}

	@Test
	public void isValid03() throws Exception {
		assertFalse(ResourceType.isValid("MeDiA"));
	}

	@Test
	public void getTypeDefault01() throws Exception {
		assertEquals(ResourceType.FILE, ResourceType
				.getDefaultResourceType("wrong-type"));
	}

	@Test
	public void getTypeDefault02() throws Exception {
		assertNotSame(ResourceType.FLASH, ResourceType
				.getDefaultResourceType("flAsh"));
	}

	@Test
	public void getSubDirForType01() throws Exception {
		assertEquals("/file", ResourceType.getDefaultResourceType(null)
				.getPath());
	}

	@Test
	public void getSubDirForType02() throws Exception {
		assertEquals("/image", ResourceType.getResourceType("Image").getPath());
	}
}
