<?php
/**
 * Internationalisation file for the FancyCaptcha plug-in
 *
 * @addtogroup Extensions
*/

$messages = array();

/* English */
$messages['en'] = array(
	'fancycaptcha-addurl' => 'Your edit includes new external links. To help protect against automated
spam, please enter the words that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-badlogin' => 'To help protect against automated password cracking, please enter the words
that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-createaccount' => 'To help protect against automated account creation, please enter the words
that appear below in the box ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-create' => 'To create the page, please enter the words that appear below in the box
([[Special:Captcha/help|more info]]):',
	'fancycaptcha-edit' => 'To edit this page, please enter the words that appear below in the box
([[Special:Captcha/help|more info]]):',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'fancycaptcha-createaccount' => 'ያልተፈለገ የመኪናነት አባልነት ለመከላከል፥ አባል ለመሆን በዚህ ምስል የታዩት እንግሊዝኛ ቃላት ወይም ቁጥር መልስ በትክክል መጻፍ ግዴታ ነው። ([[Special:Captcha/help|ይህ ምንድነው?]]) (To help protect against automated spam, you must type in the words or correct number answer exactly as seen beneath here before registering your account:)<br />',
);

/* Arabic (Meno25) */
$messages['ar'] = array(
	'fancycaptcha-addurl' => 'تعديلك يتضمن وصلات خارجية جديدة. للحماية من السخام الأوتوماتيكي، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق ([[Special:Captcha/help|معلومات إضافية]]):',
	'fancycaptcha-badlogin' => 'للمساعدة في الحماية ضد سرقة كلمات السر، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق ([[Special:Captcha/help|معلومات إضافية]]):',
	'fancycaptcha-createaccount' => 'للمساعدة في منع إنشاء حسابات بطريقة أوتوماتيكية، قم من فضلك بإدخال الكلمات التي تظهر أدناه في الصندوق ([[Special:Captcha/help|مزيد من المعلومات]]):',
	'fancycaptcha-create' => 'لإنشاء الصفحة، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق 
([[Special:Captcha/help|معلومات إضافية]]):',
	'fancycaptcha-edit' => 'لكي تعدل هذه الصفحة، من فضلك أدخل الكلمات التي تظهر بالأسفل في الصندوق 
([[Special:Captcha/help|معلومات إضافية]]):',
);

/** Bulgarian (Български)
 * @author DCLXVI
 * @author Borislav
 */
$messages['bg'] = array(
	'fancycaptcha-addurl'        => 'Текущата редакция включва нови външни препратки. Като защита от автоматизиран спам, системата изисква от потребителите да въведат думите, показани по-долу в текстовата кутия ([[Special:Captcha/help|повече информация]]):',
	'fancycaptcha-badlogin'      => 'Като защита срещу опити за налучкване на паролата ви, моля, въведете буквите, които виждате на картинката ([[Special:Captcha/help|повече информация]]):',
	'fancycaptcha-createaccount' => 'Системата за защита от автоматично създаване на потребителски сметки изисква да въведете това, което виждате в кутията по-долу ([[Special:Captcha/help|повече информация]]):',
	'fancycaptcha-create'        => 'За създаване на страницата е необходимо да се въведат думите от картинката в полето по-долу ([[Special:Captcha/help|повече информация]]):',
	'fancycaptcha-edit'          => 'За редактиране на страницата е необходимо да се въведат думите от картинката в полето по-долу ([[Special:Captcha/help|повече информация]]):',
);

$messages['br'] = array(
	'fancycaptcha-edit' => 'Liammoù diavaez nevez zo bet degaset ganeoc\'h. Evit stourm a-enep d\'ar strob emgefre, skrivit ar gerioù a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc\'h]]):',
	'fancycaptcha-addurl' => 'Liammoù diavaez nevez zo bet degaset ganeoc\'h. Evit stourm a-enep d\'ar strob emgefre, skrivit ar gerioù a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc\'h]]):',
	'fancycaptcha-create' => 'Liammoù diavaez nevez zo bet degaset ganeoc\'h. Evit stourm a-enep d\'ar strob emgefre, skrivit ar gerioù a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc\'h]]):',
	'fancycaptcha-createaccount' => 'Evit stourm a-enep d\'ar c\'hontoù  krouet ent emgefre, skrivit ar gerioù
a zeu war wel er voest a-is ([[Special:Captcha/help|gouzout hiroc\'h]]):',
);

$messages['ca'] = array(
	'fancycaptcha-addurl' => 'La vostra edició inclou nous enllaços externs. Com a protecció contra la propaganda automatitzada heu d\'escriure en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):',
	'fancycaptcha-badlogin' => 'Com a protecció contra l\'obtenció automatitzada de contrasenyes cal que escriviu en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):',
	'fancycaptcha-createaccount' => 'Com a protecció contra la creació automatitzada de nous comptes cal que escriviu en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):',
	'fancycaptcha-create' => 'Per a poder crear la pàgina heu d\'escriure en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):',
	'fancycaptcha-edit' => 'Per a poder editar la pàgina heu d\'escriure en la caixa les paraules que apareixen a continuació ([[Special:Captcha/help|més informació]]):',
);

/* Min Dong */
$messages['cdo'] = array(
	'fancycaptcha-badlogin' => 'Ôi-lāu huòng-cī tiàng-sê̤ṳ cê̤ṳ-dông puái-gāi mĭk-mā, chiāng nṳ̄ sṳ̆-ĭk â-dā̤ bēng-bēng diē-lié gì sṳ̀ ([[Special:Captcha/help|gáing sâ̤ séng-sék]]):',
);

/* Czech */
$messages['cs'] = array(
	'fancycaptcha-addurl' => 'Vaše editace obsahuje nové odkazy formou URL; v zájmu ochrany před automatickým spamováním musíte opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])',
	'fancycaptcha-edit' => 'Abyste mohli editovat tuto stránku, musíte opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])',
	'fancycaptcha-create' => 'Abyste mohli založit stránku, musíte opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])',
	'fancycaptcha-createaccount' => 'V rámci ochrany před automatickým zakládáním účtů musíte pro provedení registrace opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])',
	'fancycaptcha-badlogin' => 'V rámci ochrany před automatickým pokusům uhodnout heslo musíte opsat text z následujícího obrázku: ([[Special:Captcha/help|Co tohle znamená?]])',
);

/* Danish */
$messages['da'] = array(
	'fancycaptcha-addurl' => 'Din ændring tilføjer nye eksterne henvisninger. For at beskytte mod automatiseret spam, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-badlogin' => 'For at beskytte mod automatiske forsøg på at gætte kodeord, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-createaccount' => 'For at beskytte mod automatisk oprettelse af brugernavne, der bruges til spam, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-create' => 'For at oprette en ny side, skal du indtaste ordet som vises nedenfor i feltet under det. ([[Special:Captcha/help|mere information]]):',
	'fancycaptcha-edit' => 'or at redigere denne side
([[Special:Captcha/help|more info]]):',
);

/** German (Deutsch)
 * @author Raimond Spekking
 */
$messages['de'] = array(
	'fancycaptcha-addurl'        => 'Deine Bearbeitung enthält neue externe Links. Zum Schutz vor automatisiertem Spamming gib das folgende Wort in das Feld unten ein. Klicke dann erneut auf „Seite speichern“ [[{{ns:special}}:Captcha/help|(Fragen oder Probleme?)]].',
	'fancycaptcha-badlogin'      => 'Zum Schutz vor einer Kompromittierung deines Benutzerkontos gib das folgende Wort in das Feld unten ein [[{{ns:special}}:Captcha/help|(Fragen oder Probleme?)]]:',
	'fancycaptcha-createaccount' => 'Zum Schutz vor automatisierter Anlage von Benutzerkonten gib das folgende Wort in das Feld unten ein  [[{{ns:special}}:Captcha/help|(Fragen oder Probleme?)]].',
	'fancycaptcha-create'        => 'Zur Erstellung der Seite gib das folgende Wort in das Feld unten ein [[{{ns:special}}:Captcha/help|(Fragen oder Probleme?)]].',
	'fancycaptcha-edit'          => 'Zur Bearbeitung der Seite gib das folgende Wort in das Feld unten ein [[{{ns:special}}:Captcha/help|(Fragen oder Probleme?)]].',
);

/** Greek (Ελληνικά)
 * @author Consta
 */
$messages['el'] = array(
	'fancycaptcha-create' => 'Για να δημιουργήσετε αυτήν την σελίδα, παρακαλώ εισάγετε τις λέξεις που εμφανίζονται παρακάτω μέσα στο κουτί
([[Special:Captcha/help|περισσότερες πληροφορίες]]):',
	'fancycaptcha-edit'   => 'Για να επεξεργαστείτε αυτήν την σελίδα, παρακαλώ εισάγετε τις λέξεις που εμφανίζονται παρακάτω μέσα στο κουτί
([[Special:Captcha/help|περισσότερες πληροφορίες]]):',
);

/* Spanish */
$messages['es'] = array(
	'fancycaptcha-addurl' => 'Tu edición incluye nuevos enlaces externos. Para protegernos contra el spam automatizado, por favor introduce en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):',
	'fancycaptcha-createaccount' => 'Para evitar la creación automatizada de cuentas, introduce por favor en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):',
	'fancycaptcha-create' => 'Para crear la página, por favor introduce en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):',
	'fancycaptcha-edit' => 'Para editar esta página, por favor introduce en el recuadro las palabras que aparecen debajo ([[Special:Captcha/help|más información]]):',
);

/** فارسی
 * @author Huji
 */
$messages['fa'] = array(
	'fancycaptcha-addurl'        => 'ویرایش شما حاوی پیوندهای خارجی جدیدی است. برای جلوگیری از هرزنگاری خودکار، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',
	'fancycaptcha-badlogin'      => 'برای کمک به جلوگیری از سرقت خودکار کلمه عبور، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',
	'fancycaptcha-createaccount' => 'برای کمک به جلوگیری از ایجاد خودکار حساب کاربری، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',
	'fancycaptcha-create'        => 'برای ایجاد این صفحه، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',
	'fancycaptcha-edit'          => 'برای ویرایش این صفحه، لطفاً واژه‌ای را که در تصویر می‌بینید وارد کنید ([[Special:Captcha/help|اطلاعات بیشتر]]):',

);

/* Finnish (Niklas Laxström) */
$messages['fi'] = array(
	'fancycaptcha-addurl' => 'Muokkauksesi sisältää uusia linkkejä muille sivuille. Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):',
	'fancycaptcha-badlogin' => 'Automatisoidun salasanan murtamisen vaikeuttamiseksi kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):',
	'fancycaptcha-createaccount' => 'Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):',
	'fancycaptcha-create' => 'Muokkauksesi sisältää uusia linkkejä muille sivuille. Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):',
	'fancycaptcha-edit' => 'Muokkauksesi sisältää uusia linkkejä muille sivuille. Kirjoita kuvan sisältämät sanat alla olevaan tekstikenttään ([[Special:Captcha/help|lisätietoja]]):',
);

$messages['fo'] = array(
	'fancycaptcha-addurl' => 'Sum ein vernd ímóti sjálvvirknum konto gerð, er neyðugt hjá tær at skriva inn tey orð, sum koma fyri á myndini fyri at stovna eina kontu: <br />([[Special:Captcha/help|Hvat er hetta?]])',
	'fancycaptcha-createaccount' => 'Sum ein vernd ímóti sjálvvirknum konto gerð, er neyðugt hjá tær at skriva inn tey orð, sum koma fyri á myndini fyri at stovna eina kontu: <br />([[Special:Captcha/help|Hvat er hetta?]]):',
);

/* French */
$messages['fr'] = array(
	'fancycaptcha-addurl' => 'Votre modification inclut de nouveaux liens externes. Pour vérifier qu’il ne s’agit pas de pourriel, veuillez entrer les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha|plus d’informations]]) :',
	'fancycaptcha-badlogin' => 'Pour aider à vous protéger contre le piratage de compte par mots de passe automatiques, merci d’entrer les mots qui s’affichent dans cette boîte ([[Special:Captcha/help|Aide]]) :',
	'fancycaptcha-createaccount' => 'Comme protection contre les créations de compte abusives, veuillez entrer les mots
ci-dessous dans la boîte ([[Special:Captcha/help|plus d’informations]]) :',
	'fancycaptcha-create' => 'Votre modification inclut de nouveaux liens externes. Pour vérifier qu’il ne s’agit pas de pourriel, veuillez entrer les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha|plus d’informations]]) :',
	'fancycaptcha-edit' => 'Votre modification inclut de nouveaux liens externes. Pour vérifier qu’il ne s’agit pas de pourriel, veuillez entrer les mots qui apparaissent dans la boîte ci-dessous ([[Special:Captcha|plus d’informations]]) :',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'fancycaptcha-addurl'        => 'Voutra modificacion encllut de novéls lims de defôr. Coment protèccion contre lo spame ôtomatico, volyéd entrar los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :',
	'fancycaptcha-badlogin'      => 'Coment protèccion contre les tentatives de cracâjo de mots de pâssa ôtomatisâs per des bots, volyéd entrar los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :',
	'fancycaptcha-createaccount' => 'Coment protèccion contre les crèacions de compto abusives, volyéd entrar los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :',
	'fancycaptcha-create'        => 'Por crèar ceta pâge, volyéd entrar los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :',
	'fancycaptcha-edit'          => 'Por modifiar ceta pâge, volyéd entrar los mots qu’aparèssont dens la bouèta ce-desot ([[Special:Captcha/help|més d’enformacions]]) :',
);

/** Irish (Gaeilge)
 * @author SPQRobin
 */
$messages['ga'] = array(
	'fancycaptcha-createaccount' => 'Mar chosaint in éadan cuntais a chruthaítear go huathoibríoch, ionchuir na focail a thaispeántar san íomhá seo thíos: <br />([[Special:Captcha/help|tuilleadh eolais]])',
);

$messages['gl'] = array(
	'fancycaptcha-addurl' => 'A súa edición inclúe ligazóns externas novas. Para axudar na protección contra o spam
automatizado, introduza as palabras que aparecen na páxina de embaixo ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-badlogin' => 'Para contribuír a que non se descubran os contrasinais por medios automáticos, introduza
as palabras que aparecen na caixa de embaixo ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-createaccount' => 'Para contribuír contra a creación automatizada de contas, introduza as palabras
que aparecen na caixa de embaixo ([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-create' => 'Para crear a páxina, introduza as palabras que aparecen na caixa de embaixo
([[Special:Captcha/help|máis información]]):',
	'fancycaptcha-edit' => 'Para editar esta páxina, introduza as palabras que aparecen na caixa de embaixo
([[Special:Captcha/help|máis información]]):',
);

/* Hebrew (Rotem Liss) */
$messages['he'] = array(
	'fancycaptcha-addurl'        => 'עריכתכם כוללת קישורים חיצוניים חדשים. כהגנה מפני ספאם אוטומטי, אנא הקלידו את המילים המופיעות להלן בתיבה ([[{{ns:special}}:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-badlogin'      => 'כהגנה מפני פריצת סיסמאות אוטומטית, אנא הקלידו את המילים המופיעות להלן בתיבה ([[{{ns:special}}:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-createaccount' => 'כהגנה מפני יצירת חשבונות אוטומטית, אנא הקלידו את המילים המופיעות להלן בתיבה ([[{{ns:special}}:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-create'        => 'כדי ליצור את הדף, אנא הקלידו את המילים המופיעות להלן בתיבה ([[{{ns:special}}:Captcha/help|מידע נוסף]]):',
	'fancycaptcha-edit'          => 'כדי לערוך את הדף, אנא הקלידו את המילים המופיעות להלן בתיבה ([[{{ns:special}}:Captcha/help|מידע נוסף]]):',
);

$messages['hr'] = array(
	'fancycaptcha-addurl' => 'Vaše uređivanje sadrži nove vanjske poveznice. Kao zaštitu od automatskog spama,
molimo unesite slova koja vidite na slici dolje: ([[Special:Captcha/help|Pomoć]])',
	'fancycaptcha-badlogin' => 'Da se spriječi automatiziranje pogađanja lozinki, molimo unesite
slova koja vidite na slici dolje: <br />([[Special:Captcha/help|Pomoć]])',
	'fancycaptcha-createaccount' => 'Kao zaštitu od automatskog otvaranja računa, pri otvaranju računa trebate
unijeti slova koja vidite na slici: <br />([[Special:Captcha/help|Pomoć]])',
	'fancycaptcha-create' => 'Da bi stvorili novu stranicu, molimo unesite
slova koja vidite na slici dolje: <br />([[Special:Captcha/help|Pomoć]])',
	'fancycaptcha-edit' => 'Da bi uređivali ovu stranicu, molimo unesite slova koja vidite na slici dolje: <br />([[Special:Captcha/help|Pomoć]])',
);

$messages['hsb'] = array(
	'fancycaptcha-addurl' => 'W twojej změnje su nowe eksterne wotkazy. Jako škitna naprawa přećiwo awtomatiskemu spamej zapodaj prošu sćěhowace znamješka do kašćika ([[{{ns:special}}:Captcha/help|čehodla?]]).',
	'fancycaptcha-badlogin' => 'Jako škitna naprawa přećiwo awtomatiskemu zadobywanju do wužiwarskich kontow zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):',
	'fancycaptcha-createaccount' => 'Jako škitna naprawa přećiwo awtomatiskemu wutworjenju wužiwarskich kontow zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):',
	'fancycaptcha-create' => 'Zo by stronu wutworić móhł zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):',
	'fancycaptcha-edit' => 'Zo by stronu wobdźěłować móhł zapodaj prošu sćěhowace znamješka do kašćika ([[Special:Captcha/help|čehodla?]]):',
);

/* Indonesian (Ivan Lanin) */
$messages['id'] = array(
	'fancycaptcha-edit' => 'Suntingan Anda mencantumkan pranala luar baru. Untuk perlindungan terhadap spam otomatis, harap masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):',
	'fancycaptcha-badlogin' => 'Untuk membantu perlindungan terhadap perengkahan kunci sandi otomatis, harap masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):',
	'fancycaptcha-addurl' => 'Suntingan Anda mencantumkan pranala luar baru. Untuk perlindungan terhadap spam otomatis, harap masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):',
	'fancycaptcha-create' => 'Suntingan Anda mencantumkan pranala luar baru. Untuk perlindungan terhadap spam otomatis, harap masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):',
	'fancycaptcha-createaccount' => 'Untuk perlindungan terhadap pembuatan akun otomatis, tolong masukkan kata di bawah ini ke dalam kotak yang tersedia ([[Special:Captcha/help|info lengkap]]):',
);

/* Italian (BrokenArrow) */
$messages['it'] = array(
	'fancycaptcha-addurl' => 'La modifica richiesta aggiunge dei collegamenti esterni alla pagina; come misura precauzionale contro l\'inserimento automatico di spam, si prega di inserire nella casella sottostante la parola che compare distorta in questa immagine ([[{{ns:special}}:Captcha/help|come funziona?]]):',
	'fancycaptcha-badlogin' => 'Come misura precauzionale contro i tentativi di forzatura automatica della password, si prega di inserire nella casella sottostante la parola che compare distorta in questa immagine ([[{{ns:special}}:Captcha/help|come funziona?]]):',
	'fancycaptcha-createaccount' => 'Come misura di sicurezza nei confronti dei messaggi di spam automatici, si prega di inserire nella casella sottostante la parola che compare distorta in questa immagine ([[{{ns:special}}:Captcha/help|come funziona?]]):',
	'fancycaptcha-create' => 'La modifica richiesta aggiunge dei collegamenti esterni alla pagina; come misura precauzionale contro l\'inserimento automatico di spam, si prega di inserire nella casella sottostante la parola che compare distorta in questa immagine ([[{{ns:special}}:Captcha/help|come funziona?]]):',
	'fancycaptcha-edit' => 'La modifica richiesta aggiunge dei collegamenti esterni alla pagina; come misura precauzionale contro l\'inserimento automatico di spam, si prega di inserire nella casella sottostante la parola che compare distorta in questa immagine ([[{{ns:special}}:Captcha/help|come funziona?]]):',
);

/* Japanese */
$messages['ja'] = array(
	'fancycaptcha-addurl' => 'あなたの編集には新たに外部リンクが追加されています。自動で実行されるスパム行為防止のため、編集を有効にするには以下のボックスに表示される確認用の文字列を入力してください （[[Special:Captcha/help|詳細]]）:',
	'fancycaptcha-badlogin' => '自動化スクリプトによるパスワードクラック攻撃を防止するため、以下のボックスに表示される確認用の文字列を入力してください （[[Special:Captcha/help|詳細]]）:',
	'fancycaptcha-createaccount' => '自動で実行されるスパム行為防止のため、アカウントを登録するには以下のボックスに表示される確認用の文字列を入力してください。([[Special:Captcha/help|詳細]])',
	'fancycaptcha-create' => 'ページを作成するには以下のボックスに表示される確認用の文字列を入力してください。 （[[Special:Captcha/help|詳細]]）',
	'fancycaptcha-edit' => 'このページを編集するには以下のボックスに表示される確認用の文字列を入力してください。 （[[Special:Captcha/help|詳細]]）',
);

/* Kazakh Arabic */
$messages['kk-arab'] = array(
	'fancycaptcha-addurl' => 'تٷزەتۋٸڭٸزدە جاڭا سىرتقى سٸلتەمەلەر بار ەكەن. ٶزدٸك تٷردە «سپام» جاسالۋىنان قورعانۋ ٷشٸن,
تٶمەندەگٸ كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):',
	'fancycaptcha-badlogin' => 'قۇپييا سٶزدٸ ٶزدٸكتٸ بۇزدىرۋدان قورعانۋ ٷشٸن, تٶمەندەگٸ
كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):',
	'fancycaptcha-createaccount' => 'جاڭا تٸركەلگٸ ٶزدٸكتٸ جاسالۋىنان قورعانۋ ٷشٸن, تٶمەندەگٸ
كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):',
	'fancycaptcha-create' => 'تٷزەتۋٸڭٸزدە جاڭا سىرتقى سٸلتەمەلەر بار ەكەن. ٶزدٸك تٷردە «سپام» جاسالۋىنان قورعانۋ ٷشٸن,
تٶمەندەگٸ كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):',
	'fancycaptcha-edit' => 'تٷزەتۋٸڭٸزدە جاڭا سىرتقى سٸلتەمەلەر بار ەكەن. ٶزدٸك تٷردە «سپام» جاسالۋىنان قورعانۋ ٷشٸن,
تٶمەندەگٸ كٶرسەتٸلگەن سٶزدەردٸ اۋماققا ەنگٸزٸڭٸز ([[{{ns:special}}:Captcha/help|كٶبٸرەك اقپارات]]):',
);


/* Kazakh Cyrillic */
$messages['kk-cyrl'] = array(
	'fancycaptcha-addurl' => 'Түзетуіңізде жаңа сыртқы сілтемелер бар екен. Өздік түрде «спам» жасалуынан қорғану үшін,
төмендегі көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):',
	'fancycaptcha-badlogin' => 'Құпия сөзді өздікті бұздырудан қорғану үшін, төмендегі
көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):',
	'fancycaptcha-createaccount' => 'Жаңа тіркелгі өздікті жасалуынан қорғану үшін, төмендегі
көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):',
	'fancycaptcha-create' => 'Түзетуіңізде жаңа сыртқы сілтемелер бар екен. Өздік түрде «спам» жасалуынан қорғану үшін,
төмендегі көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):',
	'fancycaptcha-edit' => 'Түзетуіңізде жаңа сыртқы сілтемелер бар екен. Өздік түрде «спам» жасалуынан қорғану үшін,
төмендегі көрсетілген сөздерді аумаққа енгізіңіз ([[{{ns:special}}:Captcha/help|көбірек ақпарат]]):',
);

/* Kazakh Latin */
$messages['kk-latn'] = array(
	'fancycaptcha-addurl' => 'Tüzetwiñizde jaña sırtqı siltemeler bar eken. Özdik türde «spam» jasalwınan qorğanw üşin,
tömendegi körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):',
	'fancycaptcha-badlogin' => 'Qupïya sözdi özdikti buzdırwdan qorğanw üşin, tömendegi
körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):',
	'fancycaptcha-createaccount' => 'Jaña tirkelgi özdikti jasalwınan qorğanw üşin, tömendegi
körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):',
	'fancycaptcha-create' => 'Tüzetwiñizde jaña sırtqı siltemeler bar eken. Özdik türde «spam» jasalwınan qorğanw üşin,
tömendegi körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):',
	'fancycaptcha-edit' => 'Tüzetwiñizde jaña sırtqı siltemeler bar eken. Özdik türde «spam» jasalwınan qorğanw üşin,
tömendegi körsetilgen sözderdi awmaqqa engiziñiz ([[{{ns:special}}:Captcha/help|köbirek aqparat]]):',
);

$messages['la'] = array(
	'fancycaptcha-addurl' => 'Emendatione tua insunt nexus externi; ut spam automaticum vitemus, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):',
	'fancycaptcha-badlogin' => 'Ut vitemus ne tesserae frangantur, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):',
	'fancycaptcha-createaccount' => 'Ut creationem rationum automaticam vitemus, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):',
	'fancycaptcha-create' => 'Ad paginam creandum, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):',
	'fancycaptcha-edit' => 'Ad hanc paginam recensendum, necesse est tibi in capsam inscribere verba quae sub capsa monstrantur ([[Special:Captcha/help|Quidst illud?]]):',
);

/* Lao */
$messages['lo'] = array(
	'fancycaptcha-addurl'        => 'ການດັດແກ້ຂອງທ່ານ ມີລິ້ງຄ໌ພາຍນອກ. ເພື່ອປ້ອງກັນ ສະແປມອັດຕະໂນມັດ, ກະລຸນາ ພິມຄຳສັບຂ້າງລຸ່ມນີ້ ໃສ່ໃນກັບ ([[Special:Captcha/help|ຂໍ້ມູນເພີ່ມຕື່ມ]]):',
	'fancycaptcha-badlogin'      => 'ເພື່ອຊ່ອຍປ້ອງກັນ ການສືບຄົ້ນຫາລະຫັດຜ່ານແບບອັດຕະໂນມັດ, ກະລຸນາ ພິມຄຳສັບ ຂ້າງລຸ່ມນີ້ ໃສ່ໃນກັບ ([[Special:Captcha/help|ຂໍ້ມູນເພີ່ມຕື່ມ]]):',
	'fancycaptcha-createaccount' => 'ເພື່ອປ້ອງກັນ ການສ້າງບັນຊີແບບອັດຕະໂນມດ, ກະລຸນາພິມ ຄຳສັບຂ້າງລຸ່ມນີ້​ ໃສ່ໃນກັບ ([[Special:Captcha/help|ຂໍ້ມູນເພິ່ມຕືມ]]):',
	'fancycaptcha-create'        => 'ກະລຸນາ ພິມຄຳສັບຂ້າງລຸ່ມນີ້​ ໃສ່ໃນກັບ ເພື່ອສ້າງໜ້ານີ້ ([[Special:Captcha/help|more info]]):',
	'fancycaptcha-edit'          => 'ກະລຸນາ ພິມຄຳສັບຂ້າງລຸ່ມນີ້ ໃສ່ໃນກັບ ເພື່ອ ດັດແກ້ໜ້ານີ້ ([[Special:Captcha/help|ຂໍ້ມູນເພີ່ມຕື່ມ]]):',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'fancycaptcha-addurl'        => 'Uw bewerking bevat nieuwe externe links. Voer alstublieft de woorden die
hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-badlogin'      => 'Voer alstublieft de woorden die hieronder verschijnen in het invoerveld in als bescherming tegen het automatisch kraken van wachtwoorden ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-createaccount' => 'Voer alstublieft de woorden die hieronder verschijnen in het invoerveld in
ter bescherming tegen het automatisch aanmaken van gebruikers ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-create'        => 'Uw bewerking bevat nieuwe externe links. Voer alstublieft de woorden die
hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):',
	'fancycaptcha-edit'          => 'Uw bewerking bevat nieuwe externe links. Voer alstublieft de woorden die
hieronder verschijnen in het invoerveld in als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):',
);

/* Norwegian (Jon Harald Søby) */
$messages['no'] = array(
	'fancycaptcha-addurl' => 'Din endring inkluderer nye eksterne lenker. For hjelpe oss å beskytte oss mot automatisk spam, vennligst skriv inn ordene som kommer opp i denne boksen ([[Special:Captcha/help|mer informasjon]]):',
	'fancycaptcha-badlogin' => 'For å hjelpe oss å beskytte oss mot passordtyveri, skriv inn ordene som dukker opp nedenfor i boksen ([[Special:Captcha/help|mer informasjon]]):',
	'fancycaptcha-createaccount' => 'For å beskytte mot automatisk kontooprettelse, skriv inn ordene som dukker opp i boksen nedenunder ([[Special:Captcha/help|mer informasjon]]):',
	'fancycaptcha-create' => 'For å opprette siden, vennligst skriv inn ordene som dukker opp i boksen nedenfor ([[Special:Captcha/help|mer informasjon]]):',
	'fancycaptcha-edit' => 'Din endring inneholder nye eksterne lenker. For å beskytte mot automatisk spam, vennligst skriv inn ordene som dukker opp i boksten nedenunder ([[Special:Captcha/help|mer informasjon]]):',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'fancycaptcha-addurl'        => "Vòstra modificacion inclutz de ligams extèrnes novèls. Per verificar que s’agís pas de spam automatic, entratz los mots qu'apareisson dins la boita çaijós ([[Special:Captcha/help|mai d’informacions]]) :",
	'fancycaptcha-badlogin'      => 'Per ajudar a vos protegir contra lo piratatge de compte per senhals automatics, mercés d’entrar los mots que s’afichan dins aquesta boita ([[Special:Captcha/help|Ajuda]]) :',
	'fancycaptcha-createaccount' => 'Coma proteccion contra las creacions de compte abusivas, entratz los mots çaijós dins la boita ([[Special:Captcha/help|mai d’informacions]]) :',
	'fancycaptcha-create'        => "Vòstra modificacion inclutz de ligams extèrnes novèls. Per verificar que s’agís pas de spam automatic, entratz los mots qu'apareisson dins la boita çaijós ([[Special:Captcha/help|mai d’informacions]]) :",
	'fancycaptcha-edit'          => "Vòstra modificacion inclutz de ligams extèrnes novèls. Per verificar que s’agís pas de spam automatic, entratz los mots qu'apareisson dins la boita çaijós ([[Special:Captcha/help|mai d’informacions]]) :",
);

$messages['pl'] = array(
	'fancycaptcha-addurl' => 'Twoja edycja zawiera nowe linki zewnętrzne. Ze względu na ochronę przed zautomatyzowanym spamem prosimy o wpisanie słów, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|wyjaśnienie]]):',
	'fancycaptcha-badlogin' => 'Ze względu na zabezpieczenie przed automatycznym łamaniem haseł prosimy o wpisanie słów, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|wyjaśnienie]]):',
	'fancycaptcha-createaccount' => 'Ze względu na ochronę przed automatycznym [[wikipedia:pl:spam|spamem]], aby zarejestrować się musisz wpisać słów, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|wyjaśnienie]]):',
	'fancycaptcha-create' => 'Aby utworzyć tę stronę, wpisz słowa, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|wyjaśnienie]]):',
	'fancycaptcha-edit' => 'Aby edytować tę stronę, wpisz słowa, które widzisz poniżej, do pola tekstowego ([[Special:Captcha/help|wyjaśnienie]]):',
);

/* Piedmontese (Bèrto 'd Sèra) */
$messages['pms'] = array(
	'fancycaptcha-addurl' => 'Soa modìfica a l\'ha andrinta dj\'anliure esterne neuve. Për dene na man a vardesse da la reclam aotomatisà, për piasì, 
ch\'a l\'arbata le paròle ch\'a s-ciàira ambelessì sota ([[Special:Captcha/help|për savejne dë pì]]):',
	'fancycaptcha-badlogin' => 'Për dene na man a vardesse da ij programa ch\'a fan ciav fàosse, për piasì, 
ch\'a l\'arbata le paròle ch\'a s-ciàira ambelessì sota ([[Special:Captcha/help|për savejne dë pì]]):',
	'fancycaptcha-createaccount' => 'Për dene na man a vardesse da ij programa ch\'a deurbo cont neuv n\'aotomàtich, për piasì, 
ch\'a l\'arbata le paròle ch\'a s-ciàira ambelessì sota ([[Special:Captcha/help|për savejne dë pì]]):',
	'fancycaptcha-create' => 'Për creé sta pàgina-i d\'amblé, për piasì, 
ch\'a l\'arbata le paròle ch\'a s-ciàira ambelessì sota ([[Special:Captcha/help|për savejne dë pì]]):',
	'fancycaptcha-edit' => 'Për fe-ie dle modìfiche ansima a sta pàgina-sì, për piasì, 
ch\'a l\'arbata le paròle ch\'a s-ciàira ambelessì sota ([[Special:Captcha/help|për savejne dë pì]]):',
);

/* Portuguese */
$messages['pt'] = array(
	'fancycaptcha-addurl' => 'A sua edição inclui novas ligações externas. Como prevenção contra sistemas automatizados que inserem \'\'spam\'\', por favor, introduza as palavras exibidas na seguinte caixa ([[{{ns:special}}:Captcha/help|mais informações]]):',
	'fancycaptcha-badlogin' => 'Como prevenção contra formas automatizadas de descoberta de palavras-chave, por favor, introduza as palavras exibidas na seguinte caixa ([[{{ns:special}}:Captcha/help|mais informações]]):',
	'fancycaptcha-createaccount' => 'Como prevenção contra sistemas automatizados de criação de contas, por favor, introduza as palavras exibidas na seguinte caixa ([[{{ns:special}}:Captcha/help|mais informações]]):',
	'fancycaptcha-create' => 'Para criar a página, por favor, introduza as palavras exibidas na seguinte caixa ([[{{ns:special}}:Captcha/help|mais informações]]):',
	'fancycaptcha-edit' => 'Para editar esta página, por favor, introduza as palavras exibidas na seguinte caixa ([[{{ns:special}}:Captcha/help|mais informações]]):',
);

/** Russian (Русский)
 * @author .:Ajvol:.
 */
$messages['ru'] = array(
	'fancycaptcha-addurl'        => 'Ваша правка содержит новые внешние ссылки. В целях защиты от спама, пожалуйста, введите слова, показанные ниже в рамке ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-badlogin'      => 'В целях защиты от автоматического взлома паролей, пожалуйста, введите в поле ввода буквы с изображения ([[Special:Captcha/help|подробнее]]):',
	'fancycaptcha-createaccount' => 'Для предотвращения автоматической регистрации учётных записей используется контрольная последовательность символов. Пожалуйста, введите изображённые символы в текстовое поле ниже ([[Special:Captcha/help|подробнее]]):',
	'fancycaptcha-create'        => 'Ваша правка содержит новые внешние ссылки. В целях защиты от спама, пожалуйста, введите слова, показанные ниже в рамке ([[Special:Captcha/help|подробнее…]]):',
	'fancycaptcha-edit'          => 'Ваша правка содержит новые внешние ссылки. В целях защиты от спама, пожалуйста, введите слова, показанные ниже в рамке ([[Special:Captcha/help|подробнее…]]):',
);

/* Slovak (helix84) */
$messages['sk'] = array(
	'fancycaptcha-addurl' => 'Vaša úprava obsahuje nové URL odkazy; kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku: <br />([[Special:Captcha/help|Čo je toto?]])',
	'fancycaptcha-badlogin' => 'Ako ochranu proti automatizovanému lámaniu hesiel, prosím zadajte slová z nasledujúceho obrázka do poľa pre odpoveď ([[Special:Captcha/help|viac informácií]]):',
	'fancycaptcha-createaccount' => 'Kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku, až potom bude vytvorený nový účet: <br />([[Special:Captcha/help|Čo je toto?]])',
	'fancycaptcha-create' => 'Vaša úprava obsahuje nové URL odkazy; kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku: <br />([[Special:Captcha/help|Čo je toto?]])',
	'fancycaptcha-edit' => 'Vaša úprava obsahuje nové URL odkazy; kvôli ochrane proti automatizovanému spamu je potrebné napísať slová zobrazené na tomto obrázku: <br />([[Special:Captcha/help|Čo je toto?]])',
);

/* Albanian */
$messages['sq'] = array(
	'fancycaptcha-addurl'        => 'Redaktimi juaj ka lidhje URL të reja dhe si mbrojtje kundër abuzimeve automatike duhet të shtypni çfarë shfaqet tek figura e mëposhtme:<br /> ([[Special:Captcha|Çfarë është kjo?]])',
	'fancycaptcha-create'        => 'Për të krijuar një faqe, ju lutem shtypni çfarë shfaqet tek figura e mëposhtme ([[Special:Captcha|Çfarë është kjo?]]):',
	'fancycaptcha-createaccount' => 'Për të mbrojtur kundër hapjeve të llogarive në mënyrë automatike ju lutem shtypni çfarë shfaqet tek figura e mëposhtme ([[Special:Captcha|Çfarë është kjo?]]):',
	'fancycaptcha-edit'          => 'Për të redaktuar këtë faqe ju lutem shtypni çfarë shfaqet tek figura e mëposhtme ([[Special:Captcha|Çfarë është kjo?]]):',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'fancycaptcha-addurl'        => 'Dien Beoarbaidenge änthaalt näie externe Ferbiendengen. Tou Schuts foar automatisierde Spamminge reek dät foulgjende Woud in dät Fäild ien. Klik dan fonnäien ap „Siede spiekerje“ [[{{ns:special}}:Captcha/help|(Froagen of Probleme?)]].',
	'fancycaptcha-badlogin'      => 'Toun Schuts foar ne Kompromittierenge fon dien Benutserkonto reek dät foulgjende Woud in dät Fäild hierunner ien [[{{ns:special}}:Captcha/help|(Froagen of Probleme?)]]:',
	'fancycaptcha-createaccount' => 'Toun Schuts foar automatisierde Anloage fon Benutserkonten reek dät foulgjende Woud in dät Fäild hierunner ien  [[{{ns:special}}:Captcha/help|(Froagen of Probleme?)]].',
	'fancycaptcha-create'        => 'Tou dät Moakjen fon ju Siede reek dät foulgjende Woud in dät Fäild hierunner ien
[[{{ns:special}}:Captcha/help|(Froagen of Probleme?)]].',
	'fancycaptcha-edit'          => 'Tou Beoarbaidenge fon disse Siede reek dät foulgjende Woud in dät Fäild hierunner ien
[[{{ns:special}}:Captcha/help|(Froagen of Probleme?)]].',
);

/* Swedish */
$messages['sv'] = array(
	'fancycaptcha-addurl' => 'Din ändring lägger till nya externa länkar i texten. För att skydda wikin mot
automatisk spam måste du skriva orden som visas härunder i rutan ([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-badlogin' => 'För att skydda wikin mot automatiserad lösenordknäckning måste du skriva
orden som visas härunder i rutan ([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-createaccount' => 'För att skydda wikin mot automatiskt skapade användarkonton måste du
skriva orden som visas härunder i rutan ([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-create' => 'För att skapa den här sidan måste du först skriva orden som visas härunder i rutan
([[Special:Captcha/help|mer information]]):',
	'fancycaptcha-edit' => 'För att redigera den här sidan måste du först skriva orden som visas härunder i rutan
([[Special:Captcha/help|mer information]]):',
);

/* Cantonese */
$messages['yue'] = array(
	'fancycaptcha-addurl' => '你嘅編輯包括咗新嘅外部連結。為咗防止自動化嘅濫貼，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):',
	'fancycaptcha-badlogin' => '為咗防止不當程式破解密碼，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):',
	'fancycaptcha-createaccount' => '為咗防止自動化開新戶口，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):',
	'fancycaptcha-create' => '要開一個新版，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):',
	'fancycaptcha-edit' => '要編輯呢一版，請響下面個盒度輸入下面嘅文字 ([[Special:Captcha/help|更多資訊]]):',
);

/* Chinese (Simplified) */
$messages['zh-hans'] = array(
	'fancycaptcha-addurl' => '你的编辑内容中含有本网站以外的连结。为防止不当程式大量破坏，请输入以下的文字([[Special:Captcha/help|相关信息]])：',
	'fancycaptcha-badlogin' => '为防止不当程式破解密码，请输入以下的文字([[Special:Captcha/help|相关信息]])：',
	'fancycaptcha-createaccount' => '为防止不当程式大量建立帐户，请输入以下的文字([[Special:Captcha/help|相关信息]])：',
	'fancycaptcha-create' => '为防止不当程式大量建立页面，请输入以下的文字([[Special:Captcha/help|相关信息]])：',
	'fancycaptcha-edit' => '如你想要编辑這个页面，请输入以下的文字([[Special:Captcha/help|相关信息]])：',
);

/* Chinese (Traditional) */
$messages['zh-hant'] = array(
	'fancycaptcha-addurl' => '您的編輯內容中含有本網站以外的連結。為防止不當程式大量破壞，請輸入以下的文字([[Special:Captcha/help|相關資訊]])：',
	'fancycaptcha-badlogin' => '為防止不當程式破解密碼，請輸入以下的文字([[Special:Captcha/help|相關資訊]])：',
	'fancycaptcha-createaccount' => '為防止不當程式大量建立帳戶，請輸入以下的文字([[Special:Captcha/help|相關資訊]])：',
	'fancycaptcha-create' => '為防止不當程式大量建立頁面，請輸入以下的文字([[Special:Captcha/help|相關資訊]])：',
	'fancycaptcha-edit' => '如您想要編輯此頁面，請輸入以下的文字([[Special:Captcha/help|相關資訊]])：',
);

$messages['kk'] = $messages['kk-cyrl'];
$messages['kk-cn'] = $messages['kk-arab'];
$messages['kk-kz'] = $messages['kk-cyrl'];
$messages['kk-tr'] = $messages['kk-latn'];
$messages['zh'] = $messages['zh-hans'];
$messages['zh-cn'] = $messages['zh-hans'];
$messages['zh-hk'] = $messages['zh-hant'];
$messages['zh-sg'] = $messages['zh-hant'];
$messages['zh-tw'] = $messages['zh-hans'];
$messages['zh-yue'] = $messages['yue'];
