/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tool;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

/**
 * Tests for {@link XHtmlTagTool}.
 *
 * @version $Id: XHtmlTagToolTest.java 1545 2008-02-18 14:16:01Z th-schwarz $
 */
public class XHtmlTagToolTest {

	@Test
	public void testClosingTag01() throws Exception {
	    XHtmlTagTool tag = new XHtmlTagTool("test");
	    assertEquals("<test/>", tag.toString());
    }
	
	@Test
	public void testClosingTag02() throws Exception {
	    XHtmlTagTool tag = new XHtmlTagTool("test", "");
	    assertEquals("<test></test>", tag.toString());
    }

	@Test
	public void testClosingTag03() throws Exception {
	    XHtmlTagTool tag = new XHtmlTagTool("test", "val");
	    assertEquals("<test>val</test>", tag.toString());
    }
}
