#!/usr/bin/php -q
<?php
/*
 * FCKreleaser - FCKeditor Releaser - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Join all source files of FCKpackager is a single file.
 */

// Get the main file.
$output = file_get_contents( '../_source/fckreleaser.php' ) ;

// Get all includes.
$includeDirs = array(
	'../_source/includes',
	'../_source/includes/fckpackager' ) ;

foreach ( $includeDirs as $includeDir )
{
	$dir = opendir( $includeDir ) ;

	while ( false !== ( $file = readdir( $dir ) ) )
	{
		if ( $file != '.' && $file != '..' )
		{
			$filePath = $includeDir . '/' . $file ;

			if ( !is_file( $filePath ) )
				continue ;

			$fileSource = file_get_contents( $filePath ) ;

			// Remove copyright/license comment.
			$fileSource = preg_replace(
				'#/\*.*?\*/#s',
				'', $fileSource, 1 ) ;

			$output .= "\r\n" . $fileSource ;
		}
	}

	closedir( $dir ) ;
}

// Remove all require_once calls.
$output = preg_replace(
	'/require_once.*?\r\n/s',
	'', $output ) ;

// Write the single file.
$f = @fopen( '../fckreleaser.php', 'wb' ) ;

if ( !$f )
	exit( 'It was not possible to save the "fckreleaser.php" file.' ) ;

fwrite( $f, $output ) ;
fclose( $f ) ;

echo "\n" ;
echo 'The "fckreleaser.php" file has been succesfully created!' ;
echo "\n" ;
?>
