<?php
/*
 * FCKreleaser - FCKeditor Releaser - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

function FixDirSlash( $dirPath )
{
	$dirPath = str_replace( '\\', '/', $dirPath ) ;
	
	if ( substr( $dirPath, -1, 1 ) != '/' )
		$dirPath .= '/' ;
	
	return $dirPath ;
}

function RemoveDir( $path )
{
	// Add trailing slash to $path if one is not there
	if ( !preg_match( '#[/\\\\]$#', $path ) )
		$path .= '/' ;

	$all_files = array_merge(
		glob( $path . '*' ),
		glob( $path . '\.?*' ) ) ;		// Hidden files (Unix).

	foreach ( $all_files as $file )
	{
		# Skip pseudo links to current and parent dirs (./ and ../).
		if ( preg_match( '/(\.|\.\.)$/', $file ) )
			continue;

		if ( is_file( $file ) )
			unlink( $file ) ;
		else if ( is_dir( $file ) )
			removeDir( $file ) ;
	}

	if ( is_dir( $path ) )
	   rmdir( $path ) ;
}

function GetFileExtension( $filePath )
{
	$info = pathinfo( $filePath ) ;
	return $info['extension'] ;
}

?>