<?php
/*
 * FCKreleaser - FCKeditor Releaser - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

require_once( 'common.inc' ) ;
require_once( 'fckpackager/common.inc' ) ;

class FCKVersionMarker
{
	function FCKVersionMarker()
	{}

	function Mark( $targetDir, $version )
	{
		echo "\n", 'Marking with version "', $version, '"', "\n" ;

		$targetDir = FixDirSlash( $targetDir ) ;

		$files = array(
			'fckeditor.js',
			'editor/_source/fckeditorapi.js',
			'editor/dialog/fck_about.html' ) ;

		$build = FCKVersionMarker::CalculateBuild() ;

		foreach ( $files as $file )
		{
			$data = file_get_contents( $targetDir . $file ) ;

			$data = str_replace( '[Development]', $version , $data ) ;
			$data = str_replace( '[DEV]', $build ,$data ) ;

			SaveStringToFile( $data, $targetDir . $file ) ;
		}
	}

	function CalculateBuild()
	{
		// Project start time (registration at SourceForge, actually = 2003-03-01 18:20).
		$startTime = gmmktime( 18, 20, 0, 3, 1, 2003 ) ;
		
		$currentTime = time() ;
		
		// Get the number of seconds since the project startup.
		$seconds = $currentTime - $startTime ;

		// A new build number is generated for every day quarter (6 hours).
		return floor( (float)$seconds / ( 60 * 24 * 6 ) ) ;
	}
}
?>