#!/usr/bin/php -q
<?php
/*
 * FCKreleaser - FCKeditor Releaser - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

echo( "\n" ) ;
echo( 'FCKreleaser - FCKeditor Releaser' . "\n" ) ;
echo( 'Copyright 2003-2007 Frederico Caldeira Knabben - All rights reserved' . "\n" ) ;
echo( "\n" ) ;

require_once( 'includes/fckreleaser.inc' ) ;
require_once( 'includes/fckversionmarker.inc' ) ;
require_once( 'includes/fckpackager/common.inc' ) ;
require_once( 'includes/fckpackager/fckpackager.inc' ) ;

// Check the number of arguments passed. The first one is the script name.
if ( count( $argv ) > 5 )
	ExitError( 'Invalid arguments. Operation aborted.' ) ;

if ( count( $argv ) < 4 )
	ExitError( 'Please specify the source and the target directories and the version number.' ) ;

$sourceDir	= $argv[1] ;
$targetDir	= $argv[2] ;
$version	= $argv[3] ;

// Get the package definition file.
$xmlFileName = 'fckreleaser.xml' ;

if ( isset( $argv[4] ) )
	$xmlFileName = $argv[4] ;

echo '### Release started', "\n\n" ;

// ### Copy the files.

$releaser = new FCKReleaser( $sourceDir, $targetDir, $xmlFileName ) ;
$releaser->Run() ;

// ### Set version and build information.

FCKVersionMarker::Mark( $targetDir, $version ) ;

echo "\n", '### Compress source', "\n\n" ;

// ### Run the packager in the target directory.

// Save the current directory.
$curDir = getcwd() ;

// Move to the target ;
chdir( $targetDir ) ;

// Run the packager.
$packager = new FCKPackager() ;
$packager->LoadDefinitionFile( 'fckpackager.xml' ) ;
$packager->Run() ;

// Move back to the startup dir.
chdir( $curDir ) ;

echo "\n\n", '### Release finished (version "', $version, '")', "\n" ;
?>