<?php
/*
 * FCKpackager - JavaScript Packager and Compressor - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

class FCKConstantProcessor
{
	// Public properties.
	var $RemoveDeclaration ;
	var $HasConstants ;

	// Private properties.
	var $_Constants ;
	var $_ContantsRegexPart ;

	function FCKConstantProcessor()
	{
		$this->RemoveDeclaration = TRUE ;
		$this->HasConstants = FALSE ;

		$this->_Constants = array() ;
		$this->_ContantsRegexPart = '' ;
	}

	function AddConstant( $name, $value )
	{
		if ( strlen( $this->_ContantsRegexPart ) > 0 )
			$this->_ContantsRegexPart .= '|' ;

		$this->_ContantsRegexPart .= $name ;

		$this->_Constants[ $name ] = $value ;

		$this->HasConstants = TRUE ;
	}

	function Process( $script )
	{
		if ( !$this->HasConstants )
			return $script;

		$output = $script ;

		if ( $this->RemoveDeclaration )
		{
			// /var\s+(?:BASIC_COLOR_RED|BASIC_COLOR_BLUE)\s*=.+?;/
			$output = preg_replace(
				'/var\\s+(?:' . $this->_ContantsRegexPart . ')\\s*=.+?;/m',
				'', $output ) ;
		}

		$output = preg_replace_callback(
			'/(?<!(var |...\.))(?:' . $this->_ContantsRegexPart . ')(?!\\w)/',
			array( &$this, '_Contant_Replace_Evaluator' ), $output ) ;

		return $output ;
	}

	function _Contant_Replace_Evaluator( $match )
	{
		$constantName = $match[0] ;

		if ( isset( $this->_Constants[ $constantName ] ) )
			return $this->_Constants[ $constantName ] ;
		else
			return $constantName ;
	}
}

?>