<?php
/*
 * FCKreleaser - FCKeditor Releaser - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

require_once( 'common.inc' ) ;
require_once( 'fckpackager/common.inc' ) ;
require_once( 'fckpackager/fckxmldocument.inc' ) ;
require_once( 'fckpackager/fckpreprocessor.inc' ) ;

class FCKReleaser
{
	var $_PreProcessExtensions = array( 'js','html','asp','aspx','cfc','cfm','jsp','css','xml','txt','java','php','cgi','pl','lasso','py' ) ;

	var $SourcesDir ;
	var $TargetDir ;

	var $IgnoreDirs ;
	var $IgnoreFiles ;
	var $OriginalFiles ;

	function FCKReleaser( $sourceDir, $targetDir, $xmlDefinitionFile )
	{
		// The source and target directories must end with a slash.
		$sourceDir = FixDirSlash( $sourceDir ) ;
		$targetDir = FixDirSlash( $targetDir ) ;

		$this->SourcesDir	= $sourceDir ;
		$this->TargetDir	= $targetDir ;

		$xmlDefinition = new FCKXmlDocument() ;

		if ( !$xmlDefinition->LoadFile( $xmlDefinitionFile ) )
		   ExitError( 'Could not load XML definition file "' . $xmlDefinitionFile . '"' ) ;

		// Get the root "Release" element.
		$releaseNode =& $xmlDefinition->Children[ 'RELEASE' ][0] ;

		// Builds the Directories Ignore List.
		$this->IgnoreDirs = array() ;
		if ( isset( $releaseNode->Children[ 'IGNOREDIR' ] ) )
		{
			$ignoreNodes = $releaseNode->Children[ 'IGNOREDIR' ] ;

			foreach ( $ignoreNodes as $ignoreNode )
			{
				$this->IgnoreDirs[] = FixDirSlash( $sourceDir . $ignoreNode->Attributes[ 'PATH' ] ) ;
			}
		}

		// Builds the Files Ignore List.
		$this->IgnoreFiles = array() ;
		if ( isset( $releaseNode->Children[ 'IGNOREFILE' ] ) )
		{
			$ignoreNodes = $releaseNode->Children[ 'IGNOREFILE' ] ;	
			foreach ( $ignoreNodes as $ignoreNode )
			{
				$this->IgnoreFiles[] = $sourceDir . $ignoreNode->Attributes[ 'PATH' ] ;
			}
		}

		// Builds the Files Ignore List.
		$this->OriginalFiles = array() ;
		if ( isset( $releaseNode->Children[ 'ORIGINALFILE' ] ) )
		{
			$originalNodes = $releaseNode->Children[ 'ORIGINALFILE' ] ;	
			foreach ( $originalNodes as $originalNode )
			{
				$this->OriginalFiles[] = (object)array( 
					'Source' => $originalNode->Attributes[ 'SOURCEPATH' ],
					'Target' => $originalNode->Attributes[ 'TARGETPATH' ] ) ;
			}
		}
	}

	function Run()
	{
		// For debug purposes:
		//SaveStringToFile( print_r( $this, true ), 'rel.txt' ) ;
		//exit ;

		// Deletes the target directory if it already exists.
		if ( is_dir( $this->TargetDir ) )
		{
			echo '!!! Deleting destination folder. It already exists.', "\n\n" ;
			RemoveDir( $this->TargetDir ) ;
		}

		// Copy the entire source directory
		$this->_CopyDirectory( $this->SourcesDir, $this->TargetDir ) ;

		foreach ( $this->OriginalFiles as $originalFile )
		{
			$this->_CopyOriginalFile(
				$originalFile->Source,
				$originalFile->Target ) ;
		}
	}

	function _CopyDirectory( $sourceDir, $targetDir )
	{
		$sourceDir = FixDirSlash( $sourceDir ) ;
		$targetDir = FixDirSlash( $targetDir ) ;

		// Ignore hidden directories.
		// if ( ( sourceDir.Attributes & System.IO.FileAttributes.Hidden ) != 0 )
		// 		return;

		// Check the ignore list.
		if ( in_array( $sourceDir, $this->IgnoreDirs ) )
			return ;

		echo 'Copying folder ', $sourceDir, "\n" ;
		//echo 'Copying folder ', $sourceDir, ' to ', $targetDir, "\n" ;

		if ( !is_dir( $targetDir ) )
			CreateDir( $targetDir ) ;

		// Copy files and directories.
		$sourceDirHandler = opendir( $sourceDir ) ;

		while ( $file = readdir( $sourceDirHandler ) )
		{
			// Skip ".", ".." and hidden fields (Unix). 
			if ( substr( $file, 0, 1 ) == '.' )
				continue ;

			$sourcefilePath = $sourceDir . $file ;
			$targetFilePath = $targetDir . $file ;

			if ( is_dir( $sourcefilePath ) )
			{
				$this->_CopyDirectory( $sourcefilePath, $targetFilePath ) ;
				continue ;
			}

			if ( !is_file( $sourcefilePath ) )
				continue ;

			// Ignore hidden files.
			// if ( ( oFile.Attributes & System.IO.FileAttributes.Hidden ) != 0 )
			//	continue;

			if ( in_array( $sourcefilePath, $this->IgnoreFiles ) )
				continue ;

			// echo '  Copying file ', $file, ' to ', $targetFilePath, "\n" ;

			if ( in_array( GetFileExtension( $file ), $this->_PreProcessExtensions ) )
				FCKPreProcessor::ProcessFile( $sourcefilePath, $targetFilePath ) ;
			else
				copy( $sourcefilePath, $targetFilePath ) ;
		}

		closedir( $sourceDirHandler ) ;
	}

	function _CopyOriginalFile( $sourceFile, $destinationFile )
	{
		$sourceFile			= $this->SourcesDir . $sourceFile ;
		$destinationFile	= $this->TargetDir . $destinationFile ;

		$destDir = dirname( $destinationFile ) ;

		if ( !is_dir( $destDir ) )
			CreateDir( $destDir ) ;

		echo 'Copying original file ', $sourceFile, "\n" ;

		copy( $sourceFile, $destinationFile ) ;
	}
}

?>