﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Advanced document processors.
 */

var FCKDocumentProcessor = new Object() ;
FCKDocumentProcessor._Items = new Array() ;

FCKDocumentProcessor.AppendNew = function()
{
	var oNewItem = new Object() ;
	this._Items.AddItem( oNewItem ) ;
	return oNewItem ;
}

FCKDocumentProcessor.Process = function( document )
{
	var oProcessor, i = 0 ;
	while( ( oProcessor = this._Items[i++] ) )
		oProcessor.ProcessDocument( document ) ;
}

var FCKDocumentProcessor_CreateFakeImage = function( fakeClass, realElement )
{
	var oImg = FCKTools.GetElementDocument( realElement ).createElement( 'IMG' ) ;
	oImg.className = fakeClass ;
	oImg.src = FCKConfig.FullBasePath + 'images/spacer.gif' ;
	oImg.setAttribute( '_fckfakelement', 'true', 0 ) ;
	oImg.setAttribute( '_fckrealelement', FCKTempBin.AddElement( realElement ), 0 ) ;
	return oImg ;
}

// Link Anchors
if ( FCKBrowserInfo.IsIE || FCKBrowserInfo.IsOpera )
{
	var FCKAnchorsProcessor = FCKDocumentProcessor.AppendNew() ;
	FCKAnchorsProcessor.ProcessDocument = function( document )
	{
		var aLinks = document.getElementsByTagName( 'A' ) ;

		var oLink ;
		var i = aLinks.length - 1 ;
		while ( i >= 0 && ( oLink = aLinks[i--] ) )
		{
			// If it is anchor. Doesn't matter if it's also a link (even better: we show that it's both a link and an anchor)
			if ( oLink.name.length > 0 )
			{
				//if the anchor has some content then we just add a temporary class
				if ( oLink.innerHTML !== '' )
				{
					if ( FCKBrowserInfo.IsIE )
						oLink.className += ' FCK__AnchorC' ;
				}
				else
				{
					var oImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__Anchor', oLink.cloneNode(true) ) ;
					oImg.setAttribute( '_fckanchor', 'true', 0 ) ;

					oLink.parentNode.insertBefore( oImg, oLink ) ;
					oLink.parentNode.removeChild( oLink ) ;
				}
			}
		}
	}
}

// Page Breaks
var FCKPageBreaksProcessor = FCKDocumentProcessor.AppendNew() ;
FCKPageBreaksProcessor.ProcessDocument = function( document )
{
	var aDIVs = document.getElementsByTagName( 'DIV' ) ;

	var eDIV ;
	var i = aDIVs.length - 1 ;
	while ( i >= 0 && ( eDIV = aDIVs[i--] ) )
	{
		if ( eDIV.style.pageBreakAfter == 'always' && eDIV.childNodes.length == 1 && eDIV.childNodes[0].style && eDIV.childNodes[0].style.display == 'none' )
		{
			var oFakeImage = FCKDocumentProcessor_CreateFakeImage( 'FCK__PageBreak', eDIV.cloneNode(true) ) ;

			eDIV.parentNode.insertBefore( oFakeImage, eDIV ) ;
			eDIV.parentNode.removeChild( eDIV ) ;
		}
	}
/*
	var aCenters = document.getElementsByTagName( 'CENTER' ) ;

	var oCenter ;
	var i = aCenters.length - 1 ;
	while ( i >= 0 && ( oCenter = aCenters[i--] ) )
	{
		if ( oCenter.style.pageBreakAfter == 'always' && oCenter.innerHTML.Trim().length == 0 )
		{
			var oFakeImage = FCKDocumentProcessor_CreateFakeImage( 'FCK__PageBreak', oCenter.cloneNode(true) ) ;

			oCenter.parentNode.insertBefore( oFakeImage, oCenter ) ;
			oCenter.parentNode.removeChild( oCenter ) ;
		}
	}
*/
}

// EMBED and OBJECT tags.
var FCKEmbedAndObjectProcessor = FCKDocumentProcessor.AppendNew() ;
FCKTools.Merge( FCKEmbedAndObjectProcessor,
	{
		ProcessDocument : function( doc )
		{
			var bIsDirty = FCK.IsDirty() ;

			// Process OBJECTs first, since EMBEDs can sometimes go inside OBJECTS (e.g. Flash).
			var aObjects = doc.getElementsByTagName( 'object' );
			for ( var i = aObjects.length - 1 ; i >= 0 ; i-- )
				this.ProcessObjectElement( aObjects[i] ) ;

			// Now process any EMBEDs left.
			var aEmbeds = doc.getElementsByTagName( 'embed' ) ;
			for ( var i = aEmbeds.length - 1 ; i >= 0 ; i-- )
				this.ProcessEmbedElement( aEmbeds[i] ) ;

			if ( !bIsDirty )
				FCK.ResetIsDirty() ;
		},

		ProcessHtml : function( html )
		{
			var tmp = document.createElement( 'div' ) ;
			tmp.innerHTML = html ;

			// We're only processing <OBJECT> tags from HTML right now, so let's just ignore <EMBED> tag processing here for now.
			this.ProcessObjectElement( tmp.firstChild ) ;
			return tmp.innerHTML ;
		},

		ProcessObjectElement : function( el )
		{
			var classId = el.attributes.classid ;
			if ( classId )
			{
				classId = classId.value.replace( /[ \t]/g, '' ).toLowerCase() ;
				if ( this.ObjectProcessors[classId] )
					this.ObjectProcessors[classId].Process( el ) ;
				else
					this.DefaultObjectHandler.Process( el ) ;
			}
			else
				this.DefaultObjectHandler.Process( el ) ;
		},

		ProcessEmbedElement : function( el )
		{
			var suffix = el.src.match( /\.(\w+)(?:\?[0-9A-Za-z!'()*-._~+&=]*)?$/ ) ;
			var type = el.attributes.type && el.attributes.type.nodeValue ;
			if ( type && this.EmbedMimeTypeProcessors[type] )
				this.EmbedMimeTypeProcessors[type].Process( el ) ;
			else if ( suffix )
			{
				suffix = suffix[1].toLowerCase() ;
				if ( this.EmbedSuffixProcessors[suffix] )
					this.EmbedSuffixProcessors[suffix].Process( el ) ;
				else
					this.DefaultEmbedHandler.Process( el ) ;
			}
			else
				this.DefaultEmbedHandler.Process( el ) ;
		},

		RefreshView : function( placeHolder, original )
		{
			if ( original.nodeName.IEquals( 'object' ) )
			{
				var classid = original.attributes.classid ;
				if ( classid )
				{
					classId = classId.value.replace( /[ \t]/g, '' ).toLowerCase() ;
					if ( this.ObjectProcessors[classId] )
						this.ObjectProcessors[classId].Refresh.apply( this, [placeHolder, original] );
					else
						this.DefaultObjectHandler.Refresh( placeHolder, original );
				}
				else
					this.DefaultObjectHandler.Refresh( placeHolder, original );
			}
			else
			{
				var suffix = original.src.match( /\.(\w+)(?:\?[0-9A-Za-z!'()*-._~+&=]*)?$/ ) ;
				var type = original.attributes.type && el.attributes.type.nodeValue ;
				if ( type && this.EmbedMimeTypeProcessors[type] )
					this.EmbedMimeTypeProcessors[type].Refresh.apply( this, [placeHolder, original] ) ;
				else if ( suffix )
				{
					suffix = suffix[1].toLowerCase() ;
					if ( this.EmbedSuffixProcessors[suffix] )
						this.EmbedSuffixProcessors[suffix].Refresh.apply( this, [placeHolder, original] ) ;
					else
						this.DefaultEmbedHandler.Refresh( placeHolder, original ) ;
				}
				else
					this.DefaultEmbedHandler.Refresh( placeHolder, original ) ;
			}
		},

		ObjectProcessors : {},
		EmbedSuffixProcessors : {},
		EmbedMimeTypeProcessors : {},

		// Include the "clsid:" part to classID as well, case insensitive.
		AttachObjectHandler : function( classId, obj )
		{
			classId = classId.replace( /[ \t]/g, '' ).toLowerCase() ;
			this.ObjectProcessors[classId] = obj ;
		},

		// Suffix is case insensitive.
		AttachEmbedHandlerByFileSuffix : function( suffix, obj )
		{
			this.EmbedSuffixProcessors[suffix.toLowerCase()] = obj ;
		},

		// MIME type is case sensitive since there are some MIME types that are distinguished by case alone.
		AttachEmbedHandlerByMimeType : function( mimestr, obj )
		{
			this.EmbedMimeTypeProcessors[mimestr] = obj ;
		},

		DefaultObjectHandler : 
		{
			'Process' : function( el )
			{
				var clone = el.cloneNode( true ) ;
				var fakeImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__UnknownObject', clone ) ;
				this.Refresh( fakeImg, el ) ;
				el.parentNode.replaceChild( fakeImg, el ) ;
			},

			'Refresh' : function( placeHolder, original )
			{
				if ( original.getAttribute( 'width' ) > 0 )
					placeHolder.style.width = FCKTools.ConvertHtmlSizeToStyle( original.getAttribute( 'width' ) ) ;

				if ( original.getAttribute( 'height' ) > 0 )
					placeHolder.style.height = FCKTools.ConvertHtmlSizeToStyle( original.getAttribute( 'height' ) ) ;
			}
		},

		DefaultEmbedHandler : 
		{
			'Process' : function( el )
			{
				var clone = el.cloneNode( true ) ;
				var fakeImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__UnknownObject', clone ) ;
				this.Refresh( fakeImg, el ) ;
				el.parentNode.replaceChild( fakeImg, el ) ;
			},

			'Refresh' : function( placeHolder, original )
			{
				if ( original.getAttribute( 'width' ) > 0 )
					placeHolder.style.width = FCKTools.ConvertHtmlSizeToStyle( original.getAttribute( 'width' ) ) ;

				if ( original.getAttribute( 'height' ) > 0 )
					placeHolder.style.height = FCKTools.ConvertHtmlSizeToStyle( original.getAttribute( 'height' ) ) ;
			}
		} 
	} ) ;
if ( FCKBrowserInfo.IsIE )
{
	// Protect <object> tags. See #359.
	FCKConfig.ProtectedSource.CustomRegexHandlers.push( [/<object[\s\S]+?<\/object>/gi, 
			FCKTools.Bind( FCKEmbedAndObjectProcessor, FCKEmbedAndObjectProcessor.ProcessHtml ) ] ) ;
}

FCK.GetRealElement = function( fakeElement )
{
	var e = FCKTempBin.Elements[ fakeElement.getAttribute('_fckrealelement') ] ;

	if ( fakeElement.getAttribute('_fckflash') )
	{
		if ( fakeElement.style.width.length > 0 )
				e.width = FCKTools.ConvertStyleSizeToHtml( fakeElement.style.width ) ;

		if ( fakeElement.style.height.length > 0 )
				e.height = FCKTools.ConvertStyleSizeToHtml( fakeElement.style.height ) ;
	}

	return e ;
}

// HR Processor.
// This is a IE only (tricky) thing. We protect all HR tags before loading them
// (see FCK.ProtectTags). Here we put the HRs back.
if ( FCKBrowserInfo.IsIE )
{
	FCKDocumentProcessor.AppendNew().ProcessDocument = function( document )
	{
		var aHRs = document.getElementsByTagName( 'HR' ) ;

		var eHR ;
		var i = aHRs.length - 1 ;
		while ( i >= 0 && ( eHR = aHRs[i--] ) )
		{
			// Create the replacement HR.
			var newHR = document.createElement( 'hr' ) ;
			newHR.mergeAttributes( eHR, true ) ;

			// We must insert the new one after it. insertBefore will not work in all cases.
			FCKDomTools.InsertAfterNode( eHR, newHR ) ;

			eHR.parentNode.removeChild( eHR ) ;
		}
	}
}

// INPUT:hidden Processor.
FCKDocumentProcessor.AppendNew().ProcessDocument = function( document )
{
	var aInputs = document.getElementsByTagName( 'INPUT' ) ;

	var oInput ;
	var i = aInputs.length - 1 ;
	while ( i >= 0 && ( oInput = aInputs[i--] ) )
	{
		if ( oInput.type == 'hidden' )
		{
			var oImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__InputHidden', oInput.cloneNode(true) ) ;
			oImg.setAttribute( '_fckinputhidden', 'true', 0 ) ;

			oInput.parentNode.insertBefore( oImg, oInput ) ;
			oInput.parentNode.removeChild( oInput ) ;
		}
	}
}

// Flash handler.
var FCKFlashHandler =
{
	Process : function( el )
	{
		var clone = el.cloneNode( true ) ;
		var fakeImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__Flash', clone ) ;
		fakeImg.setAttribute( '_fckflash', 'true', 0 ); 
		this.Refresh( fakeImg, el ) ;
		el.parentNode.replaceChild( fakeImg, el ) ;
	},

	Refresh : function( placeHolderImage, originalEmbed )
	{
		if ( originalEmbed.getAttribute( 'width' ) > 0 )
			placeHolderImage.style.width = FCKTools.ConvertHtmlSizeToStyle( originalEmbed.getAttribute( 'width' ) ) ;

		if ( originalEmbed.getAttribute( 'height' ) > 0 )
			placeHolderImage.style.height = FCKTools.ConvertHtmlSizeToStyle( originalEmbed.getAttribute( 'height' ) ) ;
	}
} ;
FCKEmbedAndObjectProcessor.AttachEmbedHandlerByFileSuffix( 'swf', FCKFlashHandler ) ;
FCKEmbedAndObjectProcessor.AttachEmbedHandlerByMimeType( 'application/x-shockwave-flash', FCKFlashHandler ) ;
