﻿/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Advanced document processors.
 */

var FCKDocumentProcessor = new Object() ;
FCKDocumentProcessor._Items = new Array() ;

FCKDocumentProcessor.AppendNew = function()
{
	var oNewItem = new Object() ;
	this._Items.AddItem( oNewItem ) ;
	return oNewItem ;
}

FCKDocumentProcessor.Process = function( document )
{
	var oProcessor, i = 0 ;
	while( ( oProcessor = this._Items[i++] ) )
		oProcessor.ProcessDocument( document ) ;
}

var FCKDocumentProcessor_CreateFakeImage = function( fakeClass, realElement )
{
	var oImg = FCKTools.GetElementDocument( realElement ).createElement( 'IMG' ) ;
	oImg.className = fakeClass ;
	oImg.src = FCKConfig.FullBasePath + 'images/spacer.gif' ;
	oImg.setAttribute( '_fckfakelement', 'true', 0 ) ;
	oImg.setAttribute( '_fckrealelement', FCKTempBin.AddElement( realElement ), 0 ) ;
	return oImg ;
}

// Link Anchors
if ( FCKBrowserInfo.IsIE || FCKBrowserInfo.IsOpera )
{
	var FCKAnchorsProcessor = FCKDocumentProcessor.AppendNew() ;
	FCKAnchorsProcessor.ProcessDocument = function( document )
	{
		var aLinks = document.getElementsByTagName( 'A' ) ;

		var oLink ;
		var i = aLinks.length - 1 ;
		while ( i >= 0 && ( oLink = aLinks[i--] ) )
		{
			// If it is anchor. Doesn't matter if it's also a link (even better: we show that it's both a link and an anchor)
			if ( oLink.name.length > 0 )
			{
				//if the anchor has some content then we just add a temporary class
				if ( oLink.innerHTML !== '' )
				{
					if ( FCKBrowserInfo.IsIE )
						oLink.className += ' FCK__AnchorC' ;
				}
				else
				{
					var oImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__Anchor', oLink.cloneNode(true) ) ;
					oImg.setAttribute( '_fckanchor', 'true', 0 ) ;

					oLink.parentNode.insertBefore( oImg, oLink ) ;
					oLink.parentNode.removeChild( oLink ) ;
				}
			}
		}
	}
}

// Page Breaks
var FCKPageBreaksProcessor = FCKDocumentProcessor.AppendNew() ;
FCKPageBreaksProcessor.ProcessDocument = function( document )
{
	var aDIVs = document.getElementsByTagName( 'DIV' ) ;

	var eDIV ;
	var i = aDIVs.length - 1 ;
	while ( i >= 0 && ( eDIV = aDIVs[i--] ) )
	{
		if ( eDIV.style.pageBreakAfter == 'always' && eDIV.childNodes.length == 1 && eDIV.childNodes[0].style && eDIV.childNodes[0].style.display == 'none' )
		{
			var oFakeImage = FCKDocumentProcessor_CreateFakeImage( 'FCK__PageBreak', eDIV.cloneNode(true) ) ;

			eDIV.parentNode.insertBefore( oFakeImage, eDIV ) ;
			eDIV.parentNode.removeChild( eDIV ) ;
		}
	}
/*
	var aCenters = document.getElementsByTagName( 'CENTER' ) ;

	var oCenter ;
	var i = aCenters.length - 1 ;
	while ( i >= 0 && ( oCenter = aCenters[i--] ) )
	{
		if ( oCenter.style.pageBreakAfter == 'always' && oCenter.innerHTML.Trim().length == 0 )
		{
			var oFakeImage = FCKDocumentProcessor_CreateFakeImage( 'FCK__PageBreak', oCenter.cloneNode(true) ) ;

			oCenter.parentNode.insertBefore( oFakeImage, oCenter ) ;
			oCenter.parentNode.removeChild( oCenter ) ;
		}
	}
*/
}

// EMBED and OBJECT tags.
FCKEmbedAndObjectProcessor = (function()
{
	var classidProcessors = {} ;
	var suffixProcessors = {} ;
	var contentTypeProcessors = {} ;
	var defaultObjectHandler = {
		'Process' : function( el )
		{
			var clone = el.cloneNode( true ) ;
			var fakeImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__UnknownObject', clone ) ;
			this.Refresh( fakeImg, el ) ;
			el.parentNode.replaceChild( fakeImg, el ) ;
		},

		'Refresh' : function( placeHolder, original )
		{
			if ( original.getAttribute( 'width' ) > 0 )
				placeHolder.style.width = FCKTools.ConvertHtmlSizeToStyle( original.getAttribute( 'width' ) ) ;

			if ( original.getAttribute( 'height' ) > 0 )
				placeHolder.style.height = FCKTools.ConvertHtmlSizeToStyle( original.getAttribute( 'height' ) ) ;
		}
	} ;

	var processElement = function( el )
	{
		var classId = el.nodeName.IEquals( 'object' ) && el.classid ;
		classId = classId && classId.replace( /[ \t]/g, '' ).toLowerCase() ;
		var uri = el.nodeName.IEquals( 'embed' ) && el.src ;
		var suffix = uri && uri.match( /\.(\w+)(?:\?[0-9A-Za-z!'()*-._~+&=]*)?$/ ) ;
		suffix = suffix && suffix[1] ;
		var type = el.type ;

		var retval = false ;
		if ( type && contentTypeProcessors[type] )
			retval = contentTypeProcessors[type].Process( el ) ;
		if ( !retval && classId && classidProcessors[classId] )
			retval = classidProcessors[classId].Process( el ) ;
		if ( !retval && suffix && suffixProcessors[suffix] )
			retval = suffixProcessors[suffix].Process( el ) ;
		if ( !retval )
			defaultObjectHandler.Process( el ) ;
	}

	return FCKTools.Merge( FCKDocumentProcessor.AppendNew(),
		       {
				ProcessDocument : function( doc )
				{
					var bIsDirty = FCK.IsDirty() ;

					// Process OBJECTs first, since EMBEDs can sometimes go inside OBJECTS (e.g. Flash).
					var aObjects = doc.getElementsByTagName( 'object' );
					for ( var i = aObjects.length - 1 ; i >= 0 ; i-- )
						processElement( aObjects[i] ) ;

					// Now process any EMBEDs left.
					var aEmbeds = doc.getElementsByTagName( 'embed' ) ;
					for ( var i = aEmbeds.length - 1 ; i >= 0 ; i-- )
						processElement( aEmbeds[i] ) ;

					if ( !bIsDirty )
						FCK.ResetIsDirty() ;
				},

				ProcessHtml : function( html )
				{
					var tmp = document.createElement( 'div' ) ;
					tmp.innerHTML = html ;
					processElement( tmp.firstChild ) ;
					return tmp.innerHTML ;
				},

				RefreshView : function( placeHolder, original )
				{
					var classId = original.nodeName.IEquals( 'object' ) && original.classid ;
					classId = classId && classId.replace( /[ \t]/g, '' ).toLowerCase() ;
					var uri = original.nodeName.IEquals( 'embed' ) && original.src ;
					var suffix = uri && uri.match( /\.(\w+)(?:\?[0-9A-Za-z!'()*-._~+&=]*)?$/ ) ;
					suffix = suffix && suffix[1] ;
					var type = original.type ;

					var retval = false ;
					if ( type && contentTypeProcessors[type] )
						retval = contentTypeProcessors[type].Refresh( placeHolder, original ) ;
					if ( !retval && classId && classidProcessors[classId] )
						retval = classidProcessors[classId].Refresh( placeHolder, original ) ;
					if ( !retval && suffix && suffixProcessors[suffix] )
						retval = suffixProcessors[suffix].Refresh( placeHolder, original ) ;
					if ( !retval )
						defaultObjectHandler.Refresh( placeHolder, original ) ;
				},

				// Include the "clsid:" part to classID as well, case insensitive.
				AttachClassIdHandler : function( classId, obj )
				{
					classId = classId.replace( /[ \t]/g, '' ).toLowerCase() ;
					classidProcessors[classId] = obj ;
				},

				// Suffix is case insensitive.
				AttachFileSuffixHandler : function( suffix, obj )
				{
					suffixProcessors[suffix.toLowerCase()] = obj ;
				},

				// MIME type is case sensitive since there are some MIME types that are distinguished by case alone.
				AttachContentTypeHandler : function( mimestr, obj )
				{
					contentTypeProcessors[mimestr] = obj ;
				}
			} ) ;
} )() ;

if ( FCKBrowserInfo.IsIE )
{
	// Protect <object> tags. See #359.
	FCKConfig.ProtectedSource.CustomRegexHandlers.push( [/<object[\s\S]+?<\/object>/gi, 
			FCKTools.Bind( FCKEmbedAndObjectProcessor, FCKEmbedAndObjectProcessor.ProcessHtml ) ] ) ;
}

FCK.GetRealElement = function( fakeElement )
{
	var e = FCKTempBin.Elements[ fakeElement.getAttribute('_fckrealelement') ] ;

	if ( fakeElement.getAttribute('_fckflash') )
	{
		if ( fakeElement.style.width.length > 0 )
				e.width = FCKTools.ConvertStyleSizeToHtml( fakeElement.style.width ) ;

		if ( fakeElement.style.height.length > 0 )
				e.height = FCKTools.ConvertStyleSizeToHtml( fakeElement.style.height ) ;
	}

	return e ;
}

// HR Processor.
// This is a IE only (tricky) thing. We protect all HR tags before loading them
// (see FCK.ProtectTags). Here we put the HRs back.
if ( FCKBrowserInfo.IsIE )
{
	FCKDocumentProcessor.AppendNew().ProcessDocument = function( document )
	{
		var aHRs = document.getElementsByTagName( 'HR' ) ;

		var eHR ;
		var i = aHRs.length - 1 ;
		while ( i >= 0 && ( eHR = aHRs[i--] ) )
		{
			// Create the replacement HR.
			var newHR = document.createElement( 'hr' ) ;
			newHR.mergeAttributes( eHR, true ) ;

			// We must insert the new one after it. insertBefore will not work in all cases.
			FCKDomTools.InsertAfterNode( eHR, newHR ) ;

			eHR.parentNode.removeChild( eHR ) ;
		}
	}
}

// INPUT:hidden Processor.
FCKDocumentProcessor.AppendNew().ProcessDocument = function( document )
{
	var aInputs = document.getElementsByTagName( 'INPUT' ) ;

	var oInput ;
	var i = aInputs.length - 1 ;
	while ( i >= 0 && ( oInput = aInputs[i--] ) )
	{
		if ( oInput.type == 'hidden' )
		{
			var oImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__InputHidden', oInput.cloneNode(true) ) ;
			oImg.setAttribute( '_fckinputhidden', 'true', 0 ) ;

			oInput.parentNode.insertBefore( oImg, oInput ) ;
			oInput.parentNode.removeChild( oInput ) ;
		}
	}
}

// Flash handler.
var FCKFlashHandler =
{
	Process : function( el )
	{
		if ( !el.nodeName.IEquals( 'embed' ) )
			return false ;
		var clone = el.cloneNode( true ) ;
		var fakeImg = FCKDocumentProcessor_CreateFakeImage( 'FCK__Flash', clone ) ;
		fakeImg.setAttribute( '_fckflash', 'true', 0 ); 
		this.Refresh( fakeImg, el ) ;
		el.parentNode.replaceChild( fakeImg, el ) ;
		return true ;
	},

	Refresh : function( placeHolderImage, originalEmbed )
	{
		if ( !originalEmbed.nodeName.IEquals( 'embed' ) )
			return false ;
		if ( originalEmbed.getAttribute( 'width' ) > 0 )
			placeHolderImage.style.width = FCKTools.ConvertHtmlSizeToStyle( originalEmbed.getAttribute( 'width' ) ) ;
		if ( originalEmbed.getAttribute( 'height' ) > 0 )
			placeHolderImage.style.height = FCKTools.ConvertHtmlSizeToStyle( originalEmbed.getAttribute( 'height' ) ) ;
		return true ;
	}
} ;
FCKEmbedAndObjectProcessor.AttachFileSuffixHandler( 'swf', FCKFlashHandler ) ;
FCKEmbedAndObjectProcessor.AttachContentTypeHandler( 'application/x-shockwave-flash', FCKFlashHandler ) ;
