/* @Packager.Header
<FileDescription>
	Creation and initialization of the "FCK" object. This is the main object
	that represents an editor instance.
</FileDescription>
<Author name="Frederico Caldeira Knabben" email="www.fckeditor.net" />
*/

// FCK represents the active editor instance.
var FCK = 
{
	Name		: FCKURLParams[ 'InstanceName' ],
	Status		: FCK_STATUS_NOTLOADED,
	EditMode	: FCK_EDITMODE_WYSIWYG,
	
	GetLinkedFieldValue : function()
	{
		return this.LinkedField.value ;
	},
	
	GetParentForm : function()
	{
		return this.LinkedField.form ;
	}
} ;

// Set the FCK.LinkedField reference to the field that will be used to post the
// editor data.
(function()
{
	// There is a bug on IE... getElementById returns any META tag that has the
	// name set to the ID you are looking for. So the best way in to get the array
	// by names and look for the correct one.
	// As ASP.Net generates a ID that is different from the Name, we must also
	// look for the field based on the ID (the first one is the ID).
	
	var oDocument = window.parent.document ;

	// Try to get the field using the ID.
	var eLinkedField = oDocument.getElementById( FCK.Name ) ;

	var i = 0;
	while ( eLinkedField || i == 0 )
	{
		if ( eLinkedField && eLinkedField.tagName.toLowerCase().Equals( 'input', 'textarea' ) )
		{
			FCK.LinkedField = eLinkedField ;
			break ;
		}

		eLinkedField = oDocument.getElementsByName( FCK.Name )[i++] ;
	}
})() ;

var FCKTempBin = 
{
	Elements : new Array(),

	AddElement : function( element )
	{
		var iIndex = this.Elements.length ;
		this.Elements[ iIndex ] = element ;
		return iIndex ;
	},

	RemoveElement : function( index )
	{
		var e = this.Elements[ index ] ;
		this.Elements[ index ] = null ;
		return e ;
	},

	Reset : function()
	{
		var i = 0 ;
		while ( i < this.Elements.length )
			this.Elements[ i++ ] == null ;
		this.Elements.length = 0 ;
	}
} ;