﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

if ( typeof CKEDITOR == 'undefined' )
	CKEDITOR = {};

/**
 * Load core scripts and their dependencies from _source.
 * @namespace
 * @example
 */
CKEDITOR.loader = (function()
{
	// Table of script names and their dependencies.
	var scripts =
	{
		'core/_bootstrap'		: [ 'core/config', 'core/ckeditor', 'core/scriptLoader', 'core/tools' ],
		'core/ajax'				: [ 'core/xml' ],
		'core/ckeditor'			: [ 'core/ajax', 'core/ckeditor_basic', 'core/dom', 'core/editor', 'core/dom/element', 'core/event', 'core/tools' ],
		'core/ckeditor_base'	: [],
		'core/ckeditor_basic'	: [ 'core/env', 'core/event' ],
		'core/config'			: [ 'core/ckeditor_base' ],
		'core/dom'				: [],
		'core/dom/element'		: [ 'core/dom' ],
		'core/editor'			: [ 'core/config', 'core/event', 'core/tools' ],
		'core/env'				: [],
		'core/event'			: [],
		'core/scriptLoader'		: [ 'core/dom/element', 'core/env' ],
		'core/tools'			: [ 'core/env' ],
		'core/xml'				: [ 'core/env' ]
	};

	var loadedScripts = {};

	/** @lends CKEDITOR.loader */
	return {
		basePath : (function()
		{
			// This is a copy of CKEDITOR.basePath, but requires the script having
			// "_source/core/loader.js".
			if ( CKEDITOR && CKEDITOR.basePath )
				return CKEDITOR.basePath;

			// Find out the editor directory path, based on its <script> tag.
			var path = '';
			var scripts = document.getElementsByTagName( 'script' );

			for ( var i = 0 ; i < scripts.length ; i++ )
			{
				var match = scripts[i].src.match( /(^|.*[\\\/])_source\/core\/loader.js(?:\?.*)?$/i );

				if ( match )
				{
					path = match[1];
					break;
				}
			}

			// In IE (only) the script.src string is the raw valued entered in the
			// HTML. Other browsers return the full resolved URL instead.
			if ( path.indexOf('://') == -1 )
			{
				// Absolute path.
				if ( path.indexOf( '/' ) == 0 )
					path = location.href.match( /^.*?:\/\/[^\/]*/ )[0] + path;
				// Relative path.
				else
					path = location.href.match( /^[^\?]*\// )[0] + path;
			}

			return path;
		})(),

		/**
		 * The list of loaded scripts in the loading order.
		 * @type Array
		 */
		loadedScripts : [],

		load : function( scriptName )
		{
			// Check if the script has already been loaded.
			if ( scriptName in loadedScripts )
				return;

			// Get the script dependencies list.
			var dependencies = scripts[ scriptName ];
			if ( !dependencies )
				throw 'The script name"' + scriptName + '" is not defined.';

			// Mark the script as loaded, even before really loading it, to
			// avoid cross references recursion.
			loadedScripts[ scriptName ] = true;
			
			// Load all dependencies first.
			for ( var i = 0 ; i < dependencies.length ; i++ )
				this.load( dependencies[ i ] );

			// Append this script to the list of loaded scripts.
			this.loadedScripts.push( scriptName );

			// Append the <script> element to the DOM.
			document.write( '<script src="' + this.basePath + '_source/' + scriptName + '.js" type="text/javascript"><\/script>' );
		}
	};
})();

// Check if any script has been defined for autoload.
if ( CKEDITOR._autoLoad )
{
	CKEDITOR.loader.load( CKEDITOR._autoLoad );
	delete CKEDITOR._autoLoad;
}
