﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * Load scripts asynchronously.
 * @namespace
 * @example
 */
CKEDITOR.scriptLoader = (function()
{
	var uniqueScripts = {};

	return /** @lends CKEDITOR.scriptLoader */ {
		load : function( scriptUrl, callback, scope, noCheck )
		{
			if ( noCheck !== true )
			{
				if ( uniqueScripts[ scriptUrl ] )
					return false;

				uniqueScripts[ scriptUrl ] = true;
			}

			// Create the <script> element.
			var script = new CKEDITOR.dom.element( 'script' );
			script.setAttributes( {
				type : 'text/javascript',
				src : scriptUrl } );

			if ( callback )
			{
				if ( CKEDITOR.env.ie )
				{
					script.$.onreadystatechange = function ()
					{
						if ( script.$.readyState == 'loaded' || script.$.readyState == 'complete' )
							callback.call( scope || CKEDITOR );
					}
				}
				else
				{
					script.$.onload = function()
					{
						callback.call( scope || CKEDITOR );
					}
				}
			}

			// Append it to <head>.
			script.appendTo( CKEDITOR.dom.element.getHead() );

			return true;
		},

		loadCode : function( code )
		{
			// Create the <script> element.
			var script = new CKEDITOR.dom.element( 'script' );
			script.setAttribute( 'type', 'text/javascript' );

			if ( CKEDITOR.env.ie )
				script.setText( code );
			else
				script.appendText( code );

			// Append it to <head>.
			script.appendTo( CKEDITOR.dom.element.getHead() );
		}
	};
})();
