﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.instances = {};

(function()
{
	// These function loads custom configuration files and cache the
	// CKEDITOR.editorConfig functions defined on them, so there is no need to
	// download them more than once for several instances.
	var loadConfigLoaded = {};
	var loadConfig = function( editor )
	{
		var customConfig = editor.config.customConfig;

		// Check if there is a custom config to load.
		if ( !customConfig )
			return false;

		var loadedConfig = loadConfigLoaded[ customConfig ] || ( loadConfigLoaded[ customConfig ] = { editors : [] } );
		
		// If the custom config has already been downloaded, reuse it.
		if ( loadedConfig.fn )
		{
			// Call the cached CKEDITOR.editorConfig defined in the custom
			// config file for the editor instance depending on it.
			loadedConfig.fn.call( editor, editor );

			// If there is no other customConfig in the chain, fire the
			// "configloaded" event.
			if ( editor.config.customConfig == customConfig || !loadConfig( editor ) )
				editor.fireOnce( 'configloaded' );
		}
		else
		{
			// Add the editor to the list of editors waiting for this config.
			loadedConfig.editors.push( editor ); 

			// Load the custom configuration file.
			CKEDITOR.scriptLoader.load( customConfig, function()
				{
					// If the CKEDITOR.editorConfig function has been properly
					// defined in the custom configuration file, cache it.
					if ( CKEDITOR.editorConfig )
						loadedConfig.fn = CKEDITOR.editorConfig;
					else
						loadedConfig.fn = function(){};

					delete CKEDITOR.editorConfig;

					CKEDITOR.tools.each( loadedConfig.editors, function( editor )
						{
							// Call the load config again. This time the custom
							// config is already cached and so it will get loaded.
							loadConfig( editor );
						});
					
					delete loadedConfig.editors;
				} );
		}
		
		return true;
	};

	// Overwrite the basic _replaceElement implementation with the definitive one.
	CKEDITOR.replace._replaceElement = function( textarea, config )
	{
		var textarea = new CKEDITOR.dom.element( textarea );
		textarea.hide();

		// Create the editor instance.
		var editor = new CKEDITOR.editor( textarea );
		CKEDITOR.instances[ editor.name ] = editor;
		
		// Setup the lister for the "configloaded" event.
		editor.on( 'configloaded', function()
			{
				// Overwrite the settings from the in-page config.
				if ( config )
					CKEDITOR.tools.extend( editor.config, config, true );

				// Fire the "instancecreated" event.
				CKEDITOR.fire( 'instancecreated', editor.name, editor );				
			});

		// The instance config may override the customConfig setting to avoid
		// loading the default ~/config.js file.
		if ( config && config.customConfig != undefined )
			editor.config.customConfig = config.customConfig;

		// Load configs from the custom configuration files.
		if ( !loadConfig( editor ) )
			editor.fireOnce( 'configloaded' );
	};
})();

// Set the status to "loading", which means that the main CKEDITOR object has
// been created, and the rest is getting loaded.
CKEDITOR.status = 'loading';

// Load the bootstrap script.
CKEDITOR.loader.load( 'core/_bootstrap' );
