﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

 /**
 * Represents an editor instance.
 * @constructor
 * @param {CKEDITOR.dom.element} element The original element replaced by this
 *		editor instance.
 */
CKEDITOR.editor = ( function()
{
	// The counter for automatic instance names.
	var nameCounter = 0;

	var getNewName = function()
	{
		var name = 'editor' + nameCounter++;
		return CKEDITOR.instances[ name ] ? getNewName() : name;
	};
	
	// Basic config class to inherit the default settings from CKEDITOR.config.
	var config = function()
	{}
	config.prototype = CKEDITOR.config;
	
	return function( element )
	{
		// Call the base constructor.
		CKEDITOR.event.call( this );

		this.element = element;
		this.name = element.getId() || element.getNameAtt() || getNewName();
		
		// Get the default settings.
		this.config = new config();
	};
}());

CKEDITOR.editor.prototype =
{
	// The CKEDITOR.editor.fire will always pass itself as the "editor"
	// param in CKEDITOR.event.fire. So, we override it to do that
	// automaticaly.
	fire : function( eventName, data )
	{
		return CKEDITOR.event.prototype.fire.call( this, eventName, data, this );
	},
	
	fireOnce : function( eventName, data )
	{
		return CKEDITOR.event.prototype.fireOnce.call( this, eventName, data, this );
	}
};

// "Inherit" (copy actually) from CKEDITOR.event.
CKEDITOR.tools.extend( CKEDITOR.editor.prototype, CKEDITOR.event.prototype );
