﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.instances = {};

// Overwrite the basic _replaceElement implementation with the definitive one.
CKEDITOR.replace._replaceElement = function( textarea, config )
{
	// Encapsulates the original DOM textarea in a CKEDITOR.dom.element
	// instance.
	textarea = new CKEDITOR.dom.element( textarea );
	
	// Create the editor instance.
	CKEDITOR.add( new CKEDITOR.editor( textarea, config ) );
};

CKEDITOR.add = function( editor )
{
	var name = editor.name;

	// Abort it there is already an instance with that name.
	if ( CKEDITOR.instances[ name ] )
		return;

	CKEDITOR.instances[ name ] = editor;

	CKEDITOR.fire( 'instancecreated', name, editor );
	editor.fireOnce( 'instancecreated' );
};

// Set the status to "loading", which means that the main CKEDITOR object has
// been created, and the rest is getting loaded.
CKEDITOR.status = 'loading';

// Load the bootstrap script.
CKEDITOR.loader.load( 'core/_bootstrap' );
