﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * Represents a DOM element.
 * @constructor
 * @param {Object|String} element A native DOM element or the element name for new elements.
 */
CKEDITOR.dom.element = function( element )
{
	if ( typeof element == 'string' )
		element = document.createElement( element );

	/**
	 * The native DOM element represented by this class instance.
	 * @type Object
	 */
	this.$ = element;
};

CKEDITOR.dom.element.getHead = function()
{
	var head = document.getElementsByTagName( 'head' )[0];
	return new CKEDITOR.dom.element( head );
};

CKEDITOR.dom.element.prototype =
{
	append : function( node )
	{
		this.$.appendChild( node.$ );
	},

	appendTo : function( element )
	{
		element.append( this );
	},
	
	insertAfter : function( element )
	{
		element.$.parentNode.insertBefore( this.$, element.$.nextSibling );
	},

	insertBefore : function( element )
	{
		element.$.parentNode.insertBefore( this.$, element.$ );
	},

	appendText : function( text )
	{
		this.$.appendChild( document.createTextNode( text ) );
	},

	setText : function( text )
	{
		this.$.text = text;
	},

	setHtml : function( html )
	{
		this.$.innerHTML = html;
	},

	getId : function()
	{
		return this.$.id || null;
	},

	/**
	 * The value of the "name" attribute.
	 * @example
	 * var element = new CKEDITOR.dom.element( document.getElementsByName( 'test' )[0] );
	 * alert( element.getNameAtt() == 'test' );	// true
	 */
	getNameAtt : function()
	{
		return this.$.name || null;
	},

	/**
	 * The element name. The name is always full lowercased.
	 * @example
	 * var element = new CKEDITOR.dom.element( 'span' );
	 * alert( element.getName() == 'span' );	// true
	 */
	getName : function()
	{
		// Cache the lowercased name inside a closure.
		var nodeName = this.$.nodeName.toLowerCase();

		return (
		/** @ignore */
		this.getName = function()
			{
				return nodeName;
			})();
	},

	hide : function()
	{
		this.setStyle( 'display', 'none' );
	},

	show : function()
	{
		this.setStyle( 'display', '' );
	},

	setAttribute : function( attributeName, value )
	{
		this.$.setAttribute( attributeName, value );
	},

	setAttributes : function( attributesPairs )
	{
		CKEDITOR.tools.each( attributesPairs, function( value, name )
			{
				this.$.setAttribute( name, value );
			}, this);
	},

	setStyle : function( styleName, value )
	{
		this.$.style[ styleName ] = value;
	}
};