﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * Utility functions.
 * @namespace
 * @example
 */
CKEDITOR.tools =
{
	/**
	 * Evaluates a script in a window (global) scope.
	 * @param {String} script The script code to be evaluated.
	 * @param {Object} [win] The target window. Defaults to the current window.
	 * @type undefined
	 * @example
	 * var script = 'function sample() { alert( "Go!" ); }';
	 *
	 * // Evaluates a script in the current window.
	 * CKEDITOR.tools.globalEval( script );
	 *
	 * // Evaluates a script in the parent window.
	 * CKEDITOR.tools.globalEval( script, window.parent );
	 *
	 * // Alerts "Go!" twice.
	 * window.sample();
	 * window.parent.sample();
	 */
	globalEval : function( script, win )
	{
		if ( !win )
			win = window;

		if ( win.execScript )
			win.execScript( script );	// IE
		else if ( CKEDITOR.env.webkit )
		{
			// win.eval in Safari executes in the current window environment,
			// instead of win. The following should make it work.
			var doc = win.document;
			var scriptEl = doc.createElement('script');
			scriptEl.appendChild( doc.createTextNode( script ) );
			doc.documentElement.appendChild( scriptEl );
		}
		else
			eval.call( win, script );
	},

	/**
	 * Copy the properties from one object to another. By default, properties
	 * already present in the target object <strong>are not</strong> overwritten.
	 * @param {Object} target The object to be extended.
	 * @param {Object} source The object from which copy properties.
	 * @param {Boolean} [overwrite] Indicates that properties already present
	 *		in the target object must be overwritten.
	 * @returns {Object} the extended object (target).
	 * @example
	 * // Create the sample object.
	 * var myObject =
	 * {
	 *     prop1 : true
	 * };
	 *
	 * // Extend the above object with two properties.
	 * CKEDITOR.tools.extend( myObject,
	 *     {
	 *         prop2 : true,
	 *         prop3 : true
	 *     } );
	 *
	 * // Alert "prop1", "prop2" and "prop3".
	 * for ( var p in myObject )
	 *     alert( p ) ;
	 */
	extend : function( target, source, overwrite )
	{
		this.each( source, function( value, propertyName )
			{
				if ( overwrite || target[propertyName] == undefined )
					target[propertyName] = value;
			} );
		return target;
	},

	// Call a function for each element present in an object.
	each : function( object, callback, scope )
	{
		if ( !scope )
			scope = object;

		var length = object.length;

		if ( length == undefined )
		{
			for ( var name in object )
			{
				if ( callback.call( scope, object[ name ], name ) === false )
					break;
			}
		}
		else
		{
			for ( var value, i = 0 ;
				i < length && ( ( value = object[i] ) || 1) && callback.call( scope, value, i ) !== false ; i++ )
			{}
		}
	},
	
	isArray : function( object )
	{
		return ( object && object instanceof Array );
	}
};
