﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

 /**
 * Manages plugins registration and loading.
 * @namespace
 */
CKEDITOR.plugins = (function()
{
	// List of callbacks waiting for plugins to be loaded.
	var waitingList = {};

	return {
		registeredPlugins : {},

		loadedPlugins : {},

		add : function( pluginName, pluginDefinition )
		{
			if ( this.registeredPlugins[ pluginName ] )
				throw 'The plugin name "' + pluginName + '" is already registered.';

			this.registeredPlugins[ pluginName ] = pluginDefinition;
		},

		get : function( pluginName )
		{
			return this.registeredPlugins[ pluginName ];
		},

		/**
		 * Loads one or more plugins.
		 * @param {String|Array} name The name of one or more plugins to load.
		 * @param {Function} callback A function to be called when all plugins are loaded.
		 * @param {Object} [scope] The scope object to be used for the callback call.
		 * @type {Undefined}
		 */
		load : function( name, callback, scope )
		{
			// Ensure that we have an Array of names.
			var names = CKEDITOR.tools.isArray( name ) ? name : [ name ];

			var total = names.length;

			// Nothing to load, just call the callback.
			if ( total == 0 )
			{
				callback.call( scope || window, names );
				return;
			}

			// This function is used to count the loaded plugins and call the
			// callback when finished loading.
			callback._loaded = 0;
			callback._total = total;
			var loadCheck = function( callback )
			{
				if ( ++callback._loaded == callback._total )
					callback.call( scope || window, names );
			};

			var loadedPlugins = this.loadedPlugins;

			// Loop through all names.
			CKEDITOR.tools.each( names, function( pluginName )
				{
					// If not loaded already.
					if ( pluginName && !loadedPlugins[ pluginName ] )
					{
						var waitingInfo = waitingList[ pluginName ] || ( waitingList[ pluginName ] = [] );
						waitingInfo.push( callback );

						// If this is the first call for it, go ahead loading.
						if ( waitingInfo.length == 1 )
						{
							// Calculate the plugin script path.
							var pluginPath = CKEDITOR.basePath + '_source/plugins/' + pluginName + '/';

							// Load the plugin script.
							CKEDITOR.scriptLoader.load( pluginPath + 'plugin.js', function( success )
								{
									if ( !success )
										throw '[CKEDITOR.plugins.load] Plugin name "' + pluginName + '" was not found at "' + pluginPath + 'plugin.js".';

									loadedPlugins[ pluginName ] = pluginPath;

									CKEDITOR.tools.each( waitingList[ pluginName ], function( waitingCallback )
										{
											loadCheck( waitingCallback );
										});

									delete waitingList[ pluginName ];
								});
						}
					}
					else
						loadCheck( callback );
				});
		}
	};
})();
