﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

 /**
 * Base class for resource managers, like plugins and themes.
 * @namespace
 */
CKEDITOR.resourceManager = function( basePath, fileName )
{
	this.basePath = basePath;
	this.fileName = fileName;

	// List of callbacks waiting for plugins to be loaded.
	this._waitingList = {};
};

CKEDITOR.resourceManager.prototype =
{
	registered : {},

	loaded : {},
	
	externals : {},

	add : function( name, definition )
	{
		if ( this.registered[ name ] )
			throw '[CKEDITOR.resourceManager.add] The resource name "' + name + '" is already registered.';

		this.registered[ name ] = definition;
	},

	get : function( name )
	{
		return this.registered[ name ] || null;
	},
	
	getPath : function( name )
	{
		return this.loaded[ name ] || null;
	},
	
	import : function( name, path )
	{
		if ( this.registered[ name ] || this.externals[ name ] )
			throw '[CKEDITOR.resourceManager.import] The resource name "' + name + '" is already registered or imported.';

		this.externals[ name ] = path;
	},

	/**
	 * Loads one or more items.
	 * @param {String|Array} name The name of the item to load.
	 * @param {Function} callback A function to be called when all plugins are loaded.
	 * @param {Object} [scope] The scope object to be used for the callback call.
	 * @type {Undefined}
	 */
	load : function( name, callback, scope )
	{
		// Ensure that we have an Array of names.
		var names = CKEDITOR.tools.isArray( name ) ? name : [ name ];

		var total = names.length;

		// Nothing to load, just call the callback.
		if ( total == 0 )
		{
			callback.call( scope || window, names );
			return;
		}

		// This function is used to count the loaded plugins and call the
		// callback when finished loading.
		callback._loaded = 0;
		callback._total = total;
		var loadCheck = function( callback )
		{
			if ( ++callback._loaded == callback._total )
				callback.call( scope || window, names );
		};

		var loaded = this.loaded;
		var waitingList = this._waitingList;

		// Loop through all names.
		for ( var i = 0 ; i < names.length ; i++ )
		{
			var name = names[ i ];

			// If not loaded already.
			if ( name && !loaded[ name ] && !this.registered[ name ] )
			{
				var waitingInfo = waitingList[ name ] || ( waitingList[ name ] = [] );
				waitingInfo.push( callback );

				// If this is the first call for it, go ahead loading.
				if ( waitingInfo.length == 1 )
				{
					// Calculate the plugin script path.
					var path = this.externals[ name ] || ( this.basePath + name + '/' );

					// Load the plugin script.
					CKEDITOR.scriptLoader.load( path + this.fileName + '.js', function( success )
						{
							if ( !success )
								throw '[CKEDITOR.resourceManager.load] Resource name "' + name + '" was not found at "' + path + this.fileName + '.js".';

							loaded[ name ] = path;

							// Check all callbacks that were waiting for this
							// resource.
							for ( var j = 0 ; j < waitingList[ name ].length ; j++ )
								loadCheck( waitingList[ name ][ j ] );

							delete waitingList[ name ];
						});
				}
			}
			else
				loadCheck( callback );
		}
	}
};
