/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */

package net.fckeditor.tags;

import java.io.IOException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import net.fckeditor.FCKeditor;

/**
 * TODO revise this documentation
 * FCKeditor Tag class to access the
 * {@linkplain net.fckeditor.FCKeditor container}.<br />
 * <p>
 * <b>Simple usage</b>:
 * 
 * <pre>
 * &lt;FCK:editor instanceName=&quot;EditorAccessibility&quot; width=&quot;80%&quot;
 *    height=&quot;120&quot; toolbarSet=&quot;Accessibility&quot;&gt;
 *    &lt;jsp:attribute name=&quot;value&quot;&gt;
 *      This is another test.&lt;br/&gt;The &quot;second&quot; row.
 *    &lt;/jsp:attribute&gt;
 * &lt;/FCK:editor&gt;
 * </pre>
 * 
 * </p>
 * 
 * In this example we set all the attribute for the FCKeditor tag.
 * 
 * <p>
 * <b>Advanced usage of the tag</b>:
 * 
 * <pre>
 * &lt;FCK:editor instanceName=&quot;EditorDefault&quot; basePath=&quot;/fckeditor/&quot;&gt;
 *   &lt;jsp:attribute name=&quot;value&quot;&gt;
 *     This is another test.&lt;br/&gt;The &quot;second&quot; row.
 *   &lt;/jsp:attribute&gt;
 *   &lt;jsp:body&gt;
 *     &lt;FCK:config IndentUnit=&quot;cm&quot; FontNames=&quot;Arial;Courier New;Times New Roman;Verdana&quot; /&gt;
 *   &lt;/jsp:body&gt;
 * &lt;/FCK:editor&gt;
 * </pre>
 * 
 * In this example we set the instanceName and the basePath of the editor (since
 * it is /fckeditor/ we could have omitted it because it's already the default
 * value).<br />
 * Then we used the the optional attributes to set some advanced configuration
 * settings.
 * </p>
 * 
 * @version $Id: EditorTag.java 2101 2008-06-22 22:00:48Z mosipov $
 */
public class EditorTag extends TagSupport {

	private static final long serialVersionUID = -173091731589866140L;

	private String instanceName;
	private String width;
	private String height;
	private String toolbarSet;
	private String value;
	private String basePath;

	/** The underlying FCKeditor object */
	private FCKeditor fckEditor;

	/**
	 * Sets the name for the given editor instance
	 * 
	 * @param instanceName
	 *            some name without whitespaces
	 */
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	/**
	 * Sets the width of the textarea
	 * 
	 * @param width
	 *            width of the editor instance
	 * 
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * Sets the height of the textarea
	 * 
	 * @param height
	 *            height of the editor instance
	 */
	public void setHeight(String height) {
		this.height = height;
	}

	/**
	 * Sets the name of the toolbar to display
	 * 
	 * @param toolbarSet
	 *            toolbar set of the editor instance
	 */
	public void setToolbarSet(String toolbarSet) {
		this.toolbarSet = toolbarSet;
	}

	/**
	 * Sets the editor document content
	 * 
	 * @param value
	 *            any HTML string
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * Sets the dir where the FCKeditor files reside on the server
	 * 
	 * @param basePath
	 *            basePath of the editor instance (e.g. /fckeditor)
	 */
	public void setBasePath(String basePath) {
		this.basePath = basePath;
	}

	void setConfigParamAll(Map<String, String> map) {
		fckEditor.getConfig().putAll(map);
	}

	/**
	 * Initializes the FCKeditor container and sets attributes
	 * 
	 * @return EVAL_BODY_INCLUDE
	 */
	public int doStartTag() throws JspException {
		fckEditor = new FCKeditor(
				(HttpServletRequest) pageContext.getRequest(), instanceName,
				width, height, toolbarSet, value, basePath);
		fckEditor.setValue(value);

		return EVAL_BODY_INCLUDE;
	}

	@Override
	public int doEndTag() throws JspException {

		JspWriter out = pageContext.getOut();

		try {
			out.println(fckEditor);
		} catch (IOException ioe) {
			// TODO improve exception message
			throw new JspException(
					"Error: IOException while writing to the user");
		}

		return EVAL_PAGE;
	}

}