﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Contains the second part of the {@link CKEDITOR} object
 *		definition, which defines the basic editor features to be available in
 *		the root ckeditor_basic.js file.
 */

CKEDITOR.event.implementOn( CKEDITOR );

/**
 * Forces the full CKEditor core code, in the case only the basic code has been
 * loaded (ckeditor_basic.js). This method self-destroys (becomes undefined) in
 * the first call or as soon as the full code is available.
 * @type undefined
 * @example
 * // Check if the full core code has been loaded and load it.
 * if ( CKEDITOR.loadFullCore )
 *     <b>CKEDITOR.loadFullCore()</b>;
 */
CKEDITOR.loadFullCore = function()
{
	delete CKEDITOR.loadFullCore;

	CKEDITOR.loadFullCore._loaded = true;

	var script = document.createElement( 'script' );
	script.type = 'text/javascript';
	script.src = CKEDITOR.basePath + 'ckeditor.js';

	document.getElementsByTagName( 'head' )[0].appendChild( script );
};

/**
 * The class name used to identify &lt;textarea&gt; elements to be replace
 * by CKEditor instances.
 * @type string
 * @default 'ckeditor'
 * @example
 * <b>CKEDITOR.replaceClass</b> = 'rich_editor';
 */
CKEDITOR.replaceClass = 'ckeditor';

/**
 * Enables the replacement of all textareas with class name matching
 * {@link CKEDITOR.replaceClass}.
 * @type Boolean
 * @default true
 * @example
 * // Disable the auto-replace feature.
 * <b>CKEDITOR.replaceByClassEnabled</b> = false;
 */
CKEDITOR.replaceByClassEnabled = true;

/**
 * Replaces a specific &lt;textarea&gt; with a CKEditor instance.
 * @param {object|string} elementOrIdOrName The DOM element (textarea), its
 *		ID or name.
 * @param {Object} [config] The specific configurations to apply to this
 *		editor instance. Configurations set here will override global CKEditor
 *		settings.
 * @type undefined
 * @example
 * &lt;textarea id="myfield" name="myfield"&gt;&lt:/textarea&gt;
 * ...
 * <b>CKEDITOR.replace( 'myfield' )</b>;
 * @example
 * var textarea = document.body.appendChild( document.createElement( 'textarea' ) );
 * <b>CKEDITOR.replace( textarea )</b>;
 */
CKEDITOR.replace = function( elementOrIdOrName, config )
{
	if ( CKEDITOR.env.isCompatible )
	{
		var textarea = elementOrIdOrName;

		if ( typeof textarea != 'object' )
		{
			// First look for the element id, then the name.
			var i = 0;
			var textareasByName	= document.getElementsByName( elementOrIdOrName );
			textarea = document.getElementById( elementOrIdOrName ) || textareasByName[ i++ ];

			while ( textarea )
			{
				if ( textarea.tagName.toLowerCase() == 'textarea' )
					break;
				textarea = textareasByName[ i++ ];
			}

			if ( !textarea )
				throw '[CKEDITOR.replace] The <textarea> with id or name "' + elementOrIdOrName + '" was not found.';
		}

		CKEDITOR.replace._replaceElement( textarea, config );
	}
};

// This function will be overwritten by the full core code implementation.
CKEDITOR.replace._replaceElement = function( textarea, config )
{
	// Do not replace the textarea right now, just hide it. the
	// effective replacement will be done by the full core code.
	textarea.style.visibility = 'hidden';

	// Push the textarea in the array of pending replacements.
	var pending = CKEDITOR.replace._pending || ( CKEDITOR.replace._pending = [] );
	pending.push( [ textarea, config ] );

	// Check if it is time to load the full core code.
	if ( CKEDITOR.loadFullCore && CKEDITOR.status == 'basic_ready' )
		CKEDITOR.loadFullCore();
};

/**
 * Replace all &lt;textarea&gt; elements available in the document with
 * editor instances.
 * @type undefined
 * @example
 * // Replace all &lt;textarea&gt; elements in the page.
 * CKEDITOR.replaceAll();
 * @example
 * // Replace all &lt;textarea class="myClassName"&gt; elements in the page.
 * CKEDITOR.replaceAll( 'myClassName' );
 * @example
 * // Selectively replace &lt;textarea&gt; elements, based on custom assertions.
 * CKEDITOR.replaceAll( function( textarea, config )
 *     {
 *         // Custom code to evaluate the replace, returning false
 *         // if it must not be done.
 *         // It also passes the "config" parameter, so the
 *         // developer can customize the instance.
 *     } );
 */
CKEDITOR.replaceAll = function()
{
	var textareas = document.getElementsByTagName( 'textarea' );

	for ( var i = 0 ; i < textareas.length ; i++ )
	{
		var config = null;
		var textarea = textareas[i];
		var name = textarea.name;

		// The "name" and/or "id" attribute must exist.
		if ( !textarea.name && !textarea.id )
			continue;

		if ( typeof arguments[0] == 'string' )
		{
			// The textarea class name could be passed as the function
			// parameter.

			var classRegex = new RegExp( '(?:^| )' + arguments[0] + '(?:$| )' );

			if ( !classRegex.test( textarea.className ) )
				continue;
		}
		else if ( typeof arguments[0] == 'function' )
		{
			// An assertion function could be passed as the function parameter.
			// It must explicitly return "false" to ignore a specific <textarea>.
			config = {};
			if ( arguments[0]( textarea, config ) === false )
				continue;
		}

		this.replace( textarea, config );
	}
};

if ( CKEDITOR.status == 'unloaded' )
{
	(function()
	{
		var onload = function()
		{
			// Replace all textareas with the default class name.
			if ( CKEDITOR.replaceByClassEnabled )
				CKEDITOR.replaceAll( CKEDITOR.replaceClass );

			if ( CKEDITOR.replace._pending && CKEDITOR.status == 'basic_loaded' && CKEDITOR.loadFullCore )
				CKEDITOR.loadFullCore();

			CKEDITOR.status = 'basic_ready';
		};

		if ( window.addEventListener )
			window.addEventListener( 'load', onload, false );
		else if ( window.attachEvent )
			window.attachEvent( 'onload', onload );
	})();
}

CKEDITOR.status = 'basic_loaded';
