﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.config} object, which holds the
 * default configuration settings.
 */

/**
 * Holds the default configuration settings. Changes to this object are
 * reflected in all editor instances, if not specificaly specified for those
 * instances.
 * @namespace
 * @example
 * // All editor created after the following setting will not load custom
 * // configuration files.
 * CKEDITOR.config.customConfig = '';
 */
CKEDITOR.config =
{
	/**
	 * The URL path for the custom configuration file to be loaded. If not
	 * overloaded with inline configurations, it defaults to the "config.js"
	 * file present in the root of the CKEditor installation directory.<br /><br />
	 *
	 * CKEditor will recursively load custom configuration files defined inside
	 * other custom configuration files.
	 * @type String
	 * @default '&lt;CKEditor folder&gt;/config.js'
	 * @example
	 * // Load a specific configuration file.
	 * CKEDITOR.replace( 'myfiled', { customConfig : '/myconfig.js' } );
	 * @example
	 * // Do not load any custom configuration file.
	 * CKEDITOR.replace( 'myfiled', { customConfig : '' } );
	 */
	customConfig : CKEDITOR.basePath + 'config.js',

	/**
	 * The base href URL used to resolve relative and absolute URLs in the
	 * editor content.
	 * @type String
	 * @default '' (empty string)
	 * @example
	 * config.baseHref = 'http://www.example.com/path/';
	 */
	baseHref : '',

	/**
	 * A comma separated list of plugins that are not related to editor
	 * instances. Reserved to plugins that extend the core code only.<br /><br />
	 *
	 * There are no ways to override this setting, except by editing the source
	 * code of CKEditor (_source/core/config.js).
	 * @example
	 */
	corePlugins : '',

	/**
	 * Comma separated list of plugins to load and initialize for an editor
	 * instance.
	 * @type String
	 * @default 'editingblock,elementspath,sourcearea,toolbar,wysiwygarea'
	 * @example
	 * config.plugins = 'editingblock,toolbar,wysiwygarea';
	 */
	plugins : 'editingblock,elementspath,sourcearea,toolbar,wysiwygarea',

	/**
	 * The theme to be used to build the UI.
	 * @type String
	 * @default 'default'
	 * @example
	 * config.theme = 'default';
	 */
	theme : 'default',

	/**
	 * The "theme space" to which rendering the toolbar. For the default theme,
	 * the recommended options are "top" and "bottom".
	 * @type String
	 * @default 'top'
	 * @see CKEDITOR.config.theme
	 * @example
	 * config.toolbarLocation = 'bottom';
	 */
	toolbarLocation : 'top',

	/**
	 * The mode to load at the editor startup. It depends on the plugins
	 * loaded. By default, the "wysiwyg" and "source" modes are available.
	 * @type String
	 * @default 'wysiwyg'
	 * @example
	 * config.toolbarLocation = 'source';
	 */
	startupMode : 'wysiwyg'
};
