﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview The default editing block plugin, which holds the editing area
 *		and source view.
 */

CKEDITOR.plugins.add( 'editingblock',
{
	init : function( editor, pluginPath )
	{
		editor.on( 'themespace', function( event )
			{
				if ( event.data.space == 'middle' )
					event.data.html += '<br>';
			});

		editor.on( 'themeloaded', function()
			{
				editor.fireOnce( 'editingblockready' );
			});

		editor.on( 'uiready', function()
			{
				editor.setMode( CKEDITOR.config.startupMode );
			});
	}
});

(function()
{
	var getMode = function( editor, mode )
	{
		return editor._.modes && editor._.modes[ mode ];
	};

	/**
	 * The current editing mode. An editing mode is basically a viewport for
	 * editing or content viewing. By default the possible values for this
	 * property are "wysiwyg" and "source".
	 * @type String
	 * @example
	 * alert( CKEDITOR.instances.editor1.mode );  // "wysiwyg" (e.g.)
	 */
	CKEDITOR.editor.prototype.mode = '';

	/**
	 * Registers an editing mode. This function is to be used mainly by plugins.
	 * @param {String} mode The mode name.
	 * @param {Object} modeEditor The mode editor definition.
	 * @type undefined
	 * @example
	 */
	CKEDITOR.editor.prototype.addMode = function( mode, modeEditor )
	{
		modeEditor.name = mode;
		( this._.modes || ( this._.modes = {} ) )[ mode ] = modeEditor;
	};

	/**
	 * Sets the current editing mode in this editor instance.
	 * @param {String} mode A registered mode name.
	 * @type undefined
	 * @example
	 * // Switch to "source" view.
	 * CKEDITOR.instances.editor1.setMode( 'source' );
	 */
	CKEDITOR.editor.prototype.setMode = function( mode )
	{
		var holderElement = this.getThemeSpace( 'middle' );

		// Unload previous mode.
		if ( this.mode )
			getMode( this, this.mode ).unload( holderElement );

		// Load required mode.
		var modeEditor = getMode( this, mode );
		if ( !modeEditor )
			throw '[CKEDITOR.editor.setMode] Unknown mode "' + mode + '".';

		this.mode = mode;

		modeEditor.load( holderElement );
	};
})();
