﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview The "wysiwygarea" plugin. It registers the "wysiwyg" editing
 *		mode, which handles the main editing area space.
 */

CKEDITOR.plugins.add( 'wysiwygarea',
{
	init : function( editor, pluginPath )
	{
		editor.on( 'editingblockready', function()
			{
				editor.addMode( 'wysiwyg',
					{
						load : function( holderElement )
						{
							holderElement.setHtml( '<b>WYSIWYG Editor</b>' );
						},

						unload : function( holderElement )
						{
							holderElement.setHtml( '' );
						}
					});
			});
	}
});
