﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Contains the third and last part of the {@link CKEDITOR} object
 *		definition.
 */

// Remove the CKEDITOR.loadFullCore reference defined on ckeditor_basic.
delete CKEDITOR.loadFullCore;

/**
 * Holds references to all editor instances created. The name of the properties
 * in this object correspond to instance names, and their values contains the
 * {@link CKEDITOR.editor} object representing them.
 * @type {Object}
 * @example
 * alert( <b>CKEDITOR.instances</b>.editor1.name );  // "editor1"
 */
CKEDITOR.instances = {};

// Overwrite the basic _replaceElement implementation with the definitive one.
CKEDITOR.replace._replaceElement = function( textarea, config )
{
	// Encapsulates the original DOM textarea in a CKEDITOR.dom.element
	// instance.
	textarea = new CKEDITOR.dom.element( textarea );

	// Create the editor instance.
	CKEDITOR.add( new CKEDITOR.editor( textarea, config ) );
};

/**
 * Adds an editor instance to the global {@link CKEDITOR} object. It also fires
 * the effective creation of the editor interface.
 * @param {CKEDITOR.editor} editor The editor instance to be added.
 * @type undefined
 * @example
 * var myTextarea = CKEDITOR.dom.element.getById( 'myTextarea' );
 * var myEditor = new CKEDITOR.editor( myTextarea );
 * <b>CKEDITOR.add( myEditor )</b>;
 */
CKEDITOR.add = function( editor )
{
	var name = editor.name;

	// Abort it there is already an instance with that name.
	if ( CKEDITOR.instances[ name ] )
		return;

	CKEDITOR.instances[ name ] = editor;

	CKEDITOR.fire( 'instancecreated', name, editor );
	editor.fireOnce( 'instancecreated' );
};

CKEDITOR.status = 'loaded';

// Load the bootstrap script.
CKEDITOR.loader.load( 'core/_bootstrap' );		// @Packager.RemoveLine
