﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Contains the first and essential part of the {@link CKEDITOR}
 *		object definition.
 */

// #### Compressed Code
// Must be updated on changes in the script, as well as updated in the
// ckeditor_source.js and ckeditor_basic_source.js files.

// if (!window.CKEDITOR){window.CKEDITOR=(function(){var A={_:{},status:'unloaded',basePath:(function(){var B='';var C=document.getElementsByTagName('script');for (var i=0;i<C.length;i++){var D=C[i].src.match(/(^|.*[\\\/])ckeditor(?:_basic)?(?:_source)?.js(?:\?.*)?$/i);if (D){B=D[1];break;}};if (B.indexOf('://')==-1){if (B.indexOf('/')===0) B=location.href.match(/^.*?:\/\/[^\/]*/)[0]+B;else B=location.href.match(/^[^\?]*\//)[0]+B;};return B;})()};A.scriptsPath=A.basePath+'_source/';return A;})();};

// #### Raw code
// ATTENTION: read the above "Compressed Code" notes when changing this code.

if ( !window.CKEDITOR )
{
	/**
	 * This is the API entry point. The entire CKEditor code runs under this object.
	 * @name CKEDITOR
	 * @namespace
	 * @example
	 */
	window.CKEDITOR = (function()
	{
		var CKEDITOR =
		/** @lends CKEDITOR */
		{
			/**
			 * Private object used to hold core stuff. It should not be used out of
			 * the API code as properties defined here may change at any time
			 * without notice.
			 * @private
			 */
			_ : {},

			/**
			 * Indicates the API loading status. The following status are available:
			 *		<ul>
			 *			<li><b>unloaded</b>: the API is not yet loaded.</li>
			 *			<li><b>basic_loaded</b>: the basic API features are available.</li>
			 *			<li><b>basic_ready</b>: the basic API is ready to load the full core code.</li>
			 *			<li><b>loading</b>: the full API is being loaded.</li>
			 *			<li><b>ready</b>: the API can be fully used.</li>
			 *		</ul>
			 * @type string
			 * @example
			 * if ( <b>CKEDITOR.status</b> == 'ready' )
			 * {
			 *     // The API can now be fully used.
			 * }
			 */
			status : 'unloaded',

			/**
			 * Contains the full URL for the CKEditor installation directory.
			 * @type string
			 * @example
			 * alert( <b>CKEDITOR.basePath</b> );  // "http://www.example.com/ckeditor/" (e.g.)
			 */
			basePath : (function()
			{
				// ATTENTION: fixes on this code must be ported to
				// var basePath in "core/loader.js".

				// Find out the editor directory path, based on its <script> tag.
				var path = '';
				var scripts = document.getElementsByTagName( 'script' );

				for ( var i = 0 ; i < scripts.length ; i++ )
				{
					var match = scripts[i].src.match( /(^|.*[\\\/])ckeditor(?:_basic)?(?:_source)?.js(?:\?.*)?$/i );

					if ( match )
					{
						path = match[1];
						break;
					}
				}

				// In IE (only) the script.src string is the raw valued entered in the
				// HTML. Other browsers return the full resolved URL instead.
				if ( path.indexOf('://') == -1 )
				{
					// Absolute path.
					if ( path.indexOf( '/' ) === 0 )
						path = location.href.match( /^.*?:\/\/[^\/]*/ )[0] + path;
					// Relative path.
					else
						path = location.href.match( /^[^\?]*\// )[0] + path;
				}

				return path;
			})()
		};

		CKEDITOR.scriptsPath = CKEDITOR.basePath + '_source/';

		return CKEDITOR;
	})();
}
