﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.scriptLoader} object, used to load scripts
 *		asynchronously.
 */

/**
 * Load scripts asynchronously.
 * @namespace
 * @example
 */
CKEDITOR.scriptLoader = (function()
{
	var uniqueScripts = {};

	return /** @lends CKEDITOR.scriptLoader */ {
		/**
		 * Loads an external script checking if it hasn't been already loaded
		 * previously by this function.
		 * @param {String} scriptUrl The URL pointing to the external script to
		 *		be loaded.
		 * @param {Function} [callback] A function to be called when the script
		 *		is loaded and executed
		 * @param {Object} [scope] The scope ("this" reference) to be used for
		 *		the callback call. Default to {@link CKEDITOR}.
		 * @param {Boolean} [noCheck] Indicates that the script must be loaded
		 *		anyway, not checking if it has already loaded.
		 * @returns {Boolean} A boolean indicating that the script has been
		 *		loaded. Returns false if it has already been loaded previously.
		 * @example
		 * CKEDITOR.scriptLoader.load( '/myscript.js' );
		 * @example
		 * CKEDITOR.scriptLoader.load( '/myscript.js', function( success )
		 *     {
		 *         // Alerts "true" if the script has been properly loaded.
		 *         // HTTP error 404 should return "false".
		 *         alert( success );
		 *     });
		 */
		load : function( scriptUrl, callback, scope, noCheck )
		{
			if ( noCheck !== true )
			{
				if ( uniqueScripts[ scriptUrl ] )
					return false;

				uniqueScripts[ scriptUrl ] = true;
			}

			// Create the <script> element.
			var script = new CKEDITOR.dom.element( 'script' );
			script.setAttributes( {
				type : 'text/javascript',
				src : scriptUrl } );

			if ( callback )
			{
				if ( !scope )
					scope = CKEDITOR;

				if ( CKEDITOR.env.ie )
				{
					// FIXME: For IE, we are not able to return false on error (like 404).

					/** @ignore */
					script.$.onreadystatechange = function ()
					{
						if ( script.$.readyState == 'loaded' || script.$.readyState == 'complete' )
						{
							script.$.onreadystatechange = null;
							callback.call( scope, true );
						}
					};
				}
				else
				{
					/** @ignore */
					script.$.onload = function()
					{
						callback.call( scope, true );
					};

					// FIXME: Opera and Safari will not fire onerror.

					/** @ignore */
					script.$.onerror = function()
					{
						callback.call( scope, false );
					};
				}
			}

			// Append it to <head>.
			script.appendTo( CKEDITOR.document.getHead() );

			CKEDITOR.fire( 'download', scriptUrl );		// @Packager.RemoveLine

			return true;
		},

		/**
		 * Executes a JavaScript code into the current document.
		 * @param {String} code The code to be executed.
		 * @type undefined
		 * @example
		 * CKEDITOR.scriptLoader.loadCode( 'var x = 10;' );
		 * alert( x );  // "10"
		 */
		loadCode : function( code )
		{
			// Create the <script> element.
			var script = new CKEDITOR.dom.element( 'script' );
			script.setAttribute( 'type', 'text/javascript' );
			script.appendText( code );

			// Append it to <head>.
			script.appendTo( CKEDITOR.document.getHead() );
		}
	};
})();
