﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.skins} object, which is used to
 *		manage skins loading.
 */

/**
 * Manages skins loading.
 * @namespace
 * @augments CKEDITOR.resourceManager
 * @example
 */
CKEDITOR.skins = (function()
{
	// Holds the list of loaded skins.
	var loaded = {};

	var loadCss = function( cssUrl )
	{
		// Ignore it if already loaded.
		if ( loaded[ cssUrl ] )
			return;

		loaded[ cssUrl ] = 1;

		CKEDITOR.document.appendStyleSheet( cssUrl );
	};

	/**
	 * Loads a skin part. Skins are defined in parts, which are basically
	 * separated CSS files. This function is mainly used by the core code and
	 * should not have much use out of it.
	 * @param {String} skinName The name of the skin to be loaded.
	 * @param {String} skinPart The skin part to be loaded. Common skin parts
	 *		are "editor" and "dialog".
	 * @type undefined
	 * @example
	 */
	return /** lends CKEDITOR.skins */ {

		load : function( skinName, skinPart )
		{
			loadCss( CKEDITOR.scriptsPath + 'skins/' + skinName + '/' + skinPart + '.css' );
		}
	 };
})();
