﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview The "wysiwygarea" plugin. It registers the "wysiwyg" editing
 *		mode, which handles the main editing area space.
 */

CKEDITOR.plugins.add( 'wysiwygarea',
{
	init : function( editor, pluginPath )
	{
		editor.on( 'editingBlockReady', function()
			{
				var mainElement,
					iframe,
					isLoadingData,
					isPendingFocus;

				// The following information is needed for IE only.
				var isCustomDomain = CKEDITOR.env.ie && document.domain != window.location.hostname;

				// Creates the iframe that holds the editable document.
				var createIFrame = function()
				{
					if ( iframe )
						iframe.remove();

					iframe = new CKEDITOR.dom.element( 'iframe' )
						.setAttributes({
							frameBorder : 0,
							allowTransparency : true })
						.setStyles({
							width : '100%',
							height : '100%' });

					if ( CKEDITOR.env.ie )
					{
						if ( isCustomDomain )
						{
							// The document domain must be set within the src
							// attribute.
							iframe.setAttribute( 'src',
								'javascript:void( (function(){' +
									'document.open();' +
									'document.domain="' + document.domain + '";' +
									'document.write( window.parent._cke_htmlToLoad_' + editor.name + ' );' +
									'document.close();' +
									'window.parent._cke_htmlToLoad_' + editor.name + ' = null;' +
								'})() )' );
						}
						else
							// To avoid HTTPS warnings.
							iframe.setAttribute( 'src', 'javascript:void(0)' );
					}

					// Append the new IFRAME to the main element. For IE, it
					// must be done after setting the "src", to avoid the
					// "secure/unsecure" message under HTTPS.
					mainElement.append( iframe );
				};

				// The script that is appended to the data being loaded. It
				// enables editing, and makes some
				var activationScript =
					'<script id="cke_actscrpt" type="text/javascript">' +
						'window.onload = function()' +
						'{' +
							// Remove this script from the DOM.
							'var s = document.getElementById( "cke_actscrpt" );' +
							's.parentNode.removeChild( s );' +

							// Call the temporary function for the editing
							// boostrap.
							'window.parent.CKEDITOR.instances.' + editor.name + '._.contentDomReady( window );' +
						'}' +
					'</script>';

				// Editing area bootstrap code.
				var contentDomReady = function( domWindow )
				{
					delete editor._.contentDomReady;

					var domDocument = domWindow.document,
						body = domDocument.body;

					body.spellcheck = !editor.config.disableNativeSpellChecker;

					if ( CKEDITOR.env.ie )
					{
						// Disable and re-enable the body to avoid IE from
						// taking the editing focus at startup. (#141 / #523)
						body.disabled = true;
						body.contentEditable = true;
						body.removeAttribute( 'disabled' );
					}
					else
						domDocument.designMode = 'on';

					// IE, Opera and Safari may not support it and throw
					// errors.
					try { domDocument.execCommand( 'enableObjectResizing', false, !editor.config.disableObjectResizing ) ; } catch(e) {}
					try { domDocument.execCommand( 'enableInlineTableEditing', false, !editor.config.disableNativeTableHandles ) ; } catch(e) {}

					editor.window	= new CKEDITOR.dom.window( domWindow );
					editor.document	= new CKEDITOR.dom.document( domDocument );

					editor.fire( 'contentDom' );

					isLoadingData = false;

					if ( isPendingFocus )
						editor.focus();
				};

				editor.addMode( 'wysiwyg',
					{
						load : function( holderElement, data, isSnapshot )
						{
							mainElement = holderElement;

							// Create the iframe at load for all browsers
							// except FF and IE with custom domain.
							if ( !isCustomDomain || !CKEDITOR.env.gecko )
								createIFrame();

							if ( isSnapshot )
								this.loadSnapshotData( data );
							else
								this.loadData( data );
						},

						loadData : function( data )
						{
							isLoadingData = true;

							data =
								CKEDITOR.config.docType +
								'<html dir="' + CKEDITOR.config.contentLangDirection + '">' +
								'<head>' +
									'<link href="' + CKEDITOR.config.contentsCss + '" type="text/css" rel="stylesheet" _fcktemp="true"/>' +
								'</head>' +
								'<body>' +
									editor.dataProcessor.toHtml( data ) +
								'</body>' +
								'</html>' +
								activationScript;

							// For custom domain in IE, set the global variable
							// that will temporarily hold the editor data. This
							// reference will be used in the ifram src.
							if ( isCustomDomain )
								window[ '_cke_htmlToLoad_' + editor.name ] = data;

							editor._.contentDomReady = contentDomReady;

							// We need to recreate the iframe in FF for every
							// data load, otherwise the following spellcheck
							// and execCommand features will be active only for
							// the first time.
							// The same is valid for IE with custom domain,
							// because the iframe src must be reset every time.
							if ( isCustomDomain || CKEDITOR.env.gecko )
								createIFrame();

							// For custom domain in IE, the data loading is
							// done through the src attribute of the iframe.
							if ( !isCustomDomain )
							{
								var doc = iframe.$.contentWindow.document;
								doc.open();
								doc.write( data );
								doc.close();
							}
						},

						getData : function()
						{
							return editor.dataProcessor.toDataFormat( new CKEDITOR.dom.element( iframe.$.contentWindow.document.body ) );
						},

						getSnapshotData : function()
						{
							return iframe.$.contentWindow.document.body.innerHTML;
						},

						loadSnapshotData : function( data )
						{
							iframe.$.contentWindow.document.body.innerHTML = data;
						},

						unload : function( holderElement )
						{
							editor.window = editor.document = iframe = mainElement = isPendingFocus = null;

							editor.fire( 'contentDomUnload' );
						},

						focus : function()
						{
							if ( isLoadingData )
								isPendingFocus = true;
							else if ( editor.window )
								editor.window.focus();
						}
					});
			});
	}
});

/**
 * Disables the ability of resize objects (image and tables) in the editing
 * area
 * @type Boolean
 * @default false
 * @example
 * config.disableObjectResizing = true;
 */
CKEDITOR.config.disableObjectResizing = false;

/**
 * Disables the "table tools" offered natively by the browser (currently
 * Firefox only) to make quick table editing operations, like adding or
 * deleting rows and columns.
 * @type Boolean
 * @default true
 * @example
 * config.disableNativeTableHandles = false;
 */
CKEDITOR.config.disableNativeTableHandles = true;

/**
 * Disables the built-in spell checker while typing natively available in the
 * browser (currently Firefox and Safari only).<br /><br />
 *
 * Even if word suggestions will not appear in the FCKeditor context menu, this
 * feature is useful to help quickly identifying misspelled words.<br /><br />
 *
 * This setting is currently compatible with Firefox only due to limitations in
 * other browsers.
 * @type Boolean
 * @default true
 * @example
 * config.disableNativeSpellChecker = false;
 */
CKEDITOR.config.disableNativeSpellChecker = true;
