﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/*jsl:import yuitest.js*/

// Inject the YUI Test files into the page.
// URLs copied from http://developer.yahoo.com/yui/yuitest/
document.write(
	'<script type="text/javascript" src="' +
	'_source' +		// @Packager.RemoveLine
	'tests/yuitest.js"></script>' );

document.write(
	'<script type="text/javascript" src="' +
	'_source' +		// @Packager.RemoveLine
	'core/test.js"></script>' );

(function()
{
	var createLogger = function()
	{
		document.body.appendChild( document.createElement( 'div' ) ).id = 'testLogger';
	};

	var outputResult = function( text )
	{
		var div = document.getElementById('testLogger').appendChild( document.createElement( 'div' ) );
		div.className = 'testEntry';
		div.innerHTML = text;
	};

	var htmlEncode = function( data )
	{
		if ( typeof data != 'string' )
			return data;

		return data.replace(
			/&/g, '&amp;' ).replace(
			/</g, '&lt;' ).replace(
			/>/g, '&gt;' );
	};

	window.onload = function()
	{
		createLogger();
		var runner = YAHOO.tool.TestRunner;

		var handleTestResult = function( data )
		{
			switch( data.type )
			{
				case runner.TEST_FAIL_EVENT:
					outputResult( '<span class="testFail">FAIL</span> Test named "' + data.testName + '" failed with message: "' + htmlEncode( data.error.message ) + '".<div>Expected:</div><pre>' + htmlEncode( data.error.expected ) + '<br></pre><div>Actual:</div><pre>' + htmlEncode( data.error.actual ) + '<br></pre>' );
					break;
				case runner.TEST_PASS_EVENT:
					outputResult( '<span class="testPass">PASS</span> Test named "' + data.testName + '" passed.' );
					break;
				case runner.TEST_IGNORE_EVENT:
					outputResult( '<span class="testIgnore">IGNORE</span> Test named "' + data.testName + '" was ignored.' );
					break;
			}
		};

		runner.subscribe(runner.TEST_FAIL_EVENT, handleTestResult);
		runner.subscribe(runner.TEST_IGNORE_EVENT, handleTestResult);
		runner.subscribe(runner.TEST_PASS_EVENT, handleTestResult);

		if ( window.parent && window.parent.onTestStart )
		{
			runner.subscribe(runner.TEST_CASE_BEGIN_EVENT, window.parent.onTestStart);
			runner.subscribe(runner.TEST_CASE_COMPLETE_EVENT, window.parent.onTestComplete);
		}

		runner.run();
	};
})();
