package net.fckeditor.localization.impl;

import java.util.Locale;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import net.fckeditor.localization.LocaleResolver;
import net.fckeditor.tool.Utils;

/**
 * This implementation simply returns the user locale with
 * {@link ServletRequest#getLocale()} but it has an advantage over the named
 * method. If the <code>Accept-Language</code> header is empty, the default
 * server locale will be returned. This behavior is undesired and can lead to
 * wrong localized messages. Instead, this implementation will only return the
 * locale if the header is not empty.
 * 
 * @version $Id$
 * 
 */
public class AcceptLanguageHeaderResolver implements LocaleResolver {

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.fckeditor.localization.LocaleResolver#resolveLocale(javax.servlet.http.HttpServletRequest)
	 */
	public Locale resolveLocale(HttpServletRequest request) {

		if (Utils.isNotEmpty(request.getHeader("Accept-Language")))
			return request.getLocale();
		else
			return null;
	}

}
