package net.fckeditor.handlers;

import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.localization.LocaleResolver;
import net.fckeditor.tool.Utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleResolverHandler {

	private static Logger logger = LoggerFactory
			.getLogger(LocaleResolverHandler.class);
	private static LocaleResolver localeResolver;
	private ResourceBundle rb;

	static {
		String fqcn = PropertiesLoader
				.getProperty("localization.localeResolverImpl");
		if (Utils.isEmpty(fqcn))
			logger
					.warn("No valid property found for 'localization.localeResolverImpl', using default bundle!");
			
		else {
			try {
				Class<?> clazz = Class.forName(fqcn);
				localeResolver = (LocaleResolver) clazz.newInstance();
				logger
						.info(
								"LocaleResolver initialized to {}",
								localeResolver.getClass());
			} catch (Exception e) {
				logger.error("Couldn't instantiate class [".concat(fqcn)
						.concat("], default bundle will be used!!"), e);
			}
		}
	}

	public LocaleResolverHandler(HttpServletRequest request) {
		try {
			rb = ResourceBundle.getBundle("fckeditor", localeResolver
					.resolveLocale(request), Thread.currentThread()
					.getContextClassLoader());
		} catch (Exception e) {
			rb = null;
		}
	}

	public String getString(String key) {

		try {
			return rb.getString(key);
		} catch (Exception e) {
			return PropertiesLoader.getProperty(key);
		}

	}

}
