/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.localization.LocaleResolver;
import net.fckeditor.tool.Utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @version $Id: LocaleResolverHandler.java 2234 2008-07-19 19:26:46Z mosipov $
 *
 */
public class LocaleResolverHandler {

	private static Logger logger = LoggerFactory
			.getLogger(LocaleResolverHandler.class);
	private static LocaleResolver localeResolver;
	private ResourceBundle rb;

	static {
		String fqcn = PropertiesLoader
				.getProperty("localization.localeResolverImpl");
		if (Utils.isEmpty(fqcn))
			logger
					.warn("No valid property found for 'localization.localeResolverImpl', using default bundle!");
			
		else {
			try {
				Class<?> clazz = Class.forName(fqcn);
				localeResolver = (LocaleResolver) clazz.newInstance();
				logger.info("LocaleResolver initialized to {}", localeResolver
						.getClass());
			} catch (Exception e) {
				logger.error("Couldn't instantiate class [".concat(fqcn)
						.concat("], default bundle will be used!!"), e);
			}
		}
	}

	public LocaleResolverHandler(HttpServletRequest request) {
		try {
			rb = ResourceBundle.getBundle("fckeditor", localeResolver
					.resolveLocale(request), Thread.currentThread()
					.getContextClassLoader());
		} catch (Exception e) {
			rb = null;
		}
	}

	public String getString(String key) {

		try {
			return rb.getString(key);
		} catch (Exception e) {
			return PropertiesLoader.getProperty(key);
		}

	}

}
