/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.localization.impl;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.core.Config;

import net.fckeditor.localization.LocaleResolver;

/**
 * This implementation maps directly to the JSTL locale mechanism. This is
 * recommended for thos who FMT tags for example.
 * 
 * @version $Id: JstlResolver.java 2248 2008-07-21 13:14:11Z mosipov $
 * 
 */
public class JstlResolver implements LocaleResolver {

	/*
	 * (non-Javadoc)
	 * @see net.fckeditor.localization.LocaleResolver#resolveLocale(javax.servlet.http.HttpServletRequest)
	 */
	public Locale resolveLocale(HttpServletRequest request) {

		return (Locale) Config.get(request.getSession(), Config.FMT_LOCALE);
	}

}
