/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.localization.LocaleResolver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This class wraps to a {@link LocaleResolver} implementation and retrieves
 * localized strings for a given request. This class safely returns default
 * strings if anything fails.
 * 
 * @version $Id: LocaleResolverHandler.java 2250 2008-07-21 14:08:44Z mosipov $
 * 
 */
public class LocaleResolverHandler {

	private static Logger logger = LoggerFactory
			.getLogger(LocaleResolverHandler.class);
	private static LocaleResolver localeResolver;
	private ResourceBundle rb;

	static {
		String className = PropertiesLoader
				.getProperty("localization.localeResolverImpl");

		try {
			Class<?> clazz = Class.forName(className);
			localeResolver = (LocaleResolver) clazz.newInstance();
			logger.info("LocaleResolver initialized to {}", localeResolver
					.getClass());
		} catch (Exception e) {
			logger.warn("Error while loading LocaleResolver implementation", e);
		}
	}

	/**
	 * Constructor which resolves the current user's locale.
	 * 
	 * @param request
	 *            The current request instance.
	 */
	public LocaleResolverHandler(HttpServletRequest request) {
		try {
			rb = ResourceBundle.getBundle("fckeditor", localeResolver
					.resolveLocale(request), Thread.currentThread()
					.getContextClassLoader());
		} catch (Exception e) {
			rb = null;
		}
	}

	/**
	 * Retrieves a string for a given key.
	 * 
	 * @param key
	 *            Given key.
	 * @return Localized string or default string.
	 */
	public String getString(String key) {

		try {
			return rb.getString(key);
		} catch (Exception e) {
			return PropertiesLoader.getProperty(key);
		}

	}

}
