﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview The "toolbar" plugin. Renders the default toolbar interface in
 * the editor.
 */

CKEDITOR.plugins.add( 'toolbar',
{
	init : function( editor, pluginPath )
	{
		editor.on( 'themeSpace', function( event )
			{
				if ( event.data.space == editor.config.toolbarLocation )
				{
					var output = [ '<div class="cke_toolbox">' ];

					var toolbar = editor.config.toolbar;

					for ( var r = 0 ; r < toolbar.length ; r++ )
					{
						var row = toolbar[ r ];

						output.push( '<div class="cke_toolbar">' );

						for ( var i = 0 ; i < row.length ; i++ )
						{
							var item,
								itemName = row[ i ];

							if ( itemName == '-' )
								item = CKEDITOR.ui.separator;
							else
								item = editor.ui.get( row[ i ] );

							if ( item )
								item.render( editor, output );
						}

						output.push( '</div>' );
					}

					output.push( '</div>' );

					event.data.html += output.join( '' );
				}
			});
	}
});

/**
 * The UI element that renders a toolbar separator.
 * @type Object
 * @example
 */
CKEDITOR.ui.separator =
{
	render : function( editor, output )
	{
		output.push( '<span class="cke_separator"></span>' );
	}
};

/**
 * The "theme space" to which rendering the toolbar. For the default theme,
 * the recommended options are "top" and "bottom".
 * @type String
 * @default 'top'
 * @see CKEDITOR.config.theme
 * @example
 * config.toolbarLocation = 'bottom';
 */
CKEDITOR.config.toolbarLocation = 'top';

/**
 * The toolbox (alias toolbar) definition. It is an array of toolbars (strips),
 * each one being also an array, containing a list of UI items.
 * @type Array
 * @example
 * // Defines a toolbar with only one strip containing the "Source" button, a
 * // separator and the "Bold" and "Italic" buttons.
 * <b>CKEDITOR.config.toolbar =
 * [
 *     [ 'Source', '-', 'Bold', 'Italic' ]
 * ]</b>;
 */
CKEDITOR.config.toolbar =
[
	[ 'Source', '-', 'Bold', 'Italic' ]
];
