<?php
/*
 * FCKpackager - JavaScript Packager and Compressor - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

class FCKFunctionProcessor
{
	var $_Function ;
	var $_Parameters ;

	var $_VarChars = array( 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','W','X','Y','Z','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','w','x','y','z' ) ;
	var $_VarCharsLastIndex ;

	var $_VarPrefix ;
	var $_LastCharIndex ;
	var $_NextPrefixIndex ;

	var $_IsGlobal ;

	function FCKFunctionProcessor( $function, $parameters, $isGlobal )
	{
		$this->_Function		= $function ;
		$this->_Parameters		= $isGlobal ? NULL : $parameters ;

		$this->_VarPrefix		= $isGlobal ? '_' : '' ;

		$this->_IsGlobal		= $isGlobal ;

		$this->_LastCharIndex	= 0;
		$this->_NextPrefixIndex	= 0;

		$this->_VarCharsLastIndex	= count( $this->_VarChars ) - 1 ;
	}

	function Process()
	{
		$processed = $this->_Function ;

		if ( !$this->_IsGlobal )
			$processed = $this->_ProcessVars( $processed, $this->_Parameters ) ;

		// Match "var" declarations.
		$numVarMatches = preg_match_all( '/\bvar\b\s+((?:({(?:(?>[^{}]*)|(?2))*})|[^;])+?)(?=(?:\bin\b)|;)/', $processed, $varsMatches ) ;

		if ( $numVarMatches > 0 )
		{
			$vars = array() ;

			for ( $i = 0 ; $i < $numVarMatches ; $i++ )
			{
				$varsMatch = $varsMatches[1][$i];
				
				// Removed all (...), [...] and {...} blocks from the var
				// statement to avoid problems with commas inside them.
				$varsMatch = preg_replace( '/(\((?:(?>[^\(\)]*)|(?1))*\))+/', '', $varsMatch ) ;
				$varsMatch = preg_replace( '/(\[(?:(?>[^\[\]]*)|(?1))*\])+/', '', $varsMatch ) ;
				$varsMatch = preg_replace( '/({(?:(?>[^{}]*)|(?1))*})+/', '', $varsMatch ) ;
				
				$numVarNameMatches = preg_match_all( '/(?:^|,)\s*([^\s=,]+)/', $varsMatch, $varNameMatches ) ;
				
				for ( $j = 0 ; $j < $numVarNameMatches ; $j++ )
				{
					$vars[] = $varNameMatches[1][$j] ;
				}
			}

			$processed = $this->_ProcessVars( $processed, $vars ) ;
		}

		return $processed ;
	}

	function _ProcessVars( $source, $vars )
	{
		foreach ( $vars as $var )
		{
			if ( strlen( $var) > 1 )
				$source = preg_replace( '/(?<!\w|\d|\.)' . preg_quote( $var ) . '(?!\w|\d|(?:\s*:))/', $this->_GetVarName(), $source ) ;
		}

		return $source ;
	}

	function _GetVarName()
	{
		if ( $this->_LastCharIndex == $this->_VarCharsLastIndex )
		{
			$this->_RenewPrefix() ;
			$this->_LastCharIndex = 0 ;
		}

		$var = $this->_VarPrefix . $this->_VarChars[ $this->_LastCharIndex++ ] ;

		if ( preg_match( '/(?<!\w|\d|\.)' . preg_quote( $var ) . '(?!\w|\d)/', $this->_Function ) )
			return $this->_GetVarName() ;
		else
			return $var ;
	}

	function _RenewPrefix()
	{
		if ( strlen( $this->_VarPrefix) > 0 && $this->_VarPrefix != "_" )
		{
			if ( $this->_NextPrefixIndex > $this->_VarCharsLastIndex )
				$this->_NextPrefixIndex = 0 ;
			else
				$this->_VarPrefix = substr_replace( $this->_VarPrefix, '', strlen( $this->_VarPrefix ) - 1, 1 ) ;
		}

		$this->_VarPrefix .= $this->_VarChars[ $this->_NextPrefixIndex ] ;

		$this->_NextPrefixIndex++;
	}
}

?>
