﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'htmldataprocessor',
{
	init : function( editor, pluginPath )
	{
		editor.dataProcessor =
		{
			toHtml : function( data )
			{
				// The source data is already HTML, so just return it as is.
				return data;
			},

			toDataFormat : function( element )
			{
				var writer = this.writer,
					fragment = CKEDITOR.htmlParser.fragment.fromHtml( element.getHtml() );

				writer.reset();

				fragment.writeHtml( writer );

				return writer.getHtml( true );
			},

			writer : new CKEDITOR.htmlWriter()
		};
	}
});
