﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

(function()
{
	// The sample##.html files also include this script. We don't want them to
	// run, so we redirect to the samples.html page, passing the correct
	// querystring parameter to load the desired page.

	var sampleMatch = window.location.pathname.match( /[\/\\]([^\/\\]+).html/ );
	if ( sampleMatch && sampleMatch[1] != 'sample' )
		window.location = 'sample.html?sample=' + sampleMatch[1] + ( location.search.length > 1 ? '&' + location.search.substr(1) : '' );
})();

if ( window.CKEDITOR )
{
	CKEDITOR.samples = (function()
	{
		var ajax = CKEDITOR.ajax;

		// Default values for the CKEDITOR.samples properties.
		var samples =
		{
			htmlData : '<p>No HTML data available.</p>',
			codeData : '<p>No code data available.</p>'
		};

		if ( /[?&]sample=[^&]+/.test( document.location.search ) )
		{
			var currentSample = document.location.search.match( /[?&]sample=([^&]+)/ )[1];
			var sampleData = ajax.loadXml( CKEDITOR.getUrl( '_samples/' + currentSample + '.html' ) );

			if ( sampleData )
			{
				var getDivContents = function ( id )
				{
					try
					{
						// The '//div[@id="html"]' XPath doesn't work with
						// <html xmlns"..."> in FF, Safari and Opera.
						return sampleData.getOuterXml( '//*[name()="div"][@id="' + id + '"]' );
					}
					catch(e)
					{
						// In IE instead, the "name()" expression is not
						// understood, but xmlns doens't disturb it.
						return sampleData.getOuterXml( '//div[@id="' + id + '"]' );
					}
				};

				var html = getDivContents( 'html' );
				if ( html )
					samples.htmlData = html;

				html = getDivContents( 'code' );
				if ( html )
					samples.codeData = html;
			}
		}

		return samples;
	})();

	(function()
	{
		var showCompatibilityMsg = function()
		{
			var env = CKEDITOR.env;

			var html = '<p><strong>Your browser is not compatible with CKEditor.</strong>';

			var browsers =
			{
				gecko : 'Firefox 1.5',
				ie : 'Internet Explorer 6.0',
				opera : 'Opera 9.5',
				webkit : 'Safari 3.0'
			};

			var alsoBrowsers = '';

			for ( var key in env )
			{
				if ( browsers[ key ] )
				{
					if ( env[key] )
						html += ' CKEditor is compatible with ' + browsers[ key ] + ' or higher.';
					else
						alsoBrowsers += browsers[ key ] + '+, ';
				}
			}

			alsoBrowsers = alsoBrowsers.replace( /\+,([^,]+), $/, '+ and $1' );

			html += ' It is also compatible with ' + alsoBrowsers + '.';

			html += '</p><p>With non compatible browsers, you should still be able to see and edit the contents (HTML) in a plain text field.</p>';

			document.getElementById( 'alerts' ).innerHTML = html;
		};

		var onload = function()
		{
			// Show a friendly compatibility message as soon as the page is loaded,
			// for those browsers that are not compatible with CKEditor.
			if ( !CKEDITOR.env.isCompatible )
				showCompatibilityMsg();
		};

		// Register the onload listener.
		if ( window.addEventListener )
			window.addEventListener( 'load', onload, false );
		else if ( window.attachEvent )
			window.attachEvent( 'onload', onload );
	})();
}
