﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.themes.add( 'default',
{
	build : function( editor, themePath )
	{
		var name = editor.name,
			element = editor.element,
			elementMode = editor.elementMode;

		if ( !element || elementMode == CKEDITOR.ELEMENT_MODE_NONE )
			return;

		if ( elementMode == CKEDITOR.ELEMENT_MODE_REPLACE )
			element.hide();

		// Get the HTML for the predefined spaces.
		var topHtml			= editor.fire( 'themeSpace', { space : 'top', html : '' } ).html;
		var contentsHtml	= editor.fire( 'themeSpace', { space : 'contents', html : '' } ).html;
		var bottomHtml		= editor.fireOnce( 'themeSpace', { space : 'bottom', html : '' } ).html;

		var height	= contentsHtml && editor.config.height;
		var width	= editor.config.width;

		// The editor height is considered only if the contents space got filled.
		if ( !contentsHtml )
			height = 'auto';
		else if ( !isNaN( height ) )
			height += 'px';

		if ( !isNaN( width ) )
			width += 'px';

		// Using a <div> as the outer element container can make IE goes crazy.
		// The fact is that a <textarea> is an inline element. We aim to
		// replace it with our structure, but <div> is a block element and it
		// seems to be the cause of it. Using a <span>, which is inline just
		// like <textarea>, makes it work.
		// <table> is also a block element and should not go inside a <span>,
		// not even in the places where <textarea> is valid. But this doesn't
		// bring any evident problem as it seems that tables are treated
		// differently by the browsers ("semi-inline").
		var container = CKEDITOR.dom.element.createFromHtml( [
			'<span id="cke_', name, '" class="cke_container cke_skin_', editor.config.skin, ' cke_', CKEDITOR.lang.dir, '" dir="', CKEDITOR.lang.dir, '">' +
				'<table class="cke_editor" border="0" cellspacing="0" cellpadding="0" style="width:', width, ';height:', height, '"><tbody>' +
					'<tr', topHtml		? '' : ' style="display:none"', '><td id="cke_top_'		, name, '" class="cke_top">'		, topHtml		, '</td></tr>' +
					'<tr', contentsHtml	? '' : ' style="display:none"', '><td id="cke_contents_', name, '" class="cke_contents" style="height:100%">'	, contentsHtml	, '</td></tr>' +
					'<tr', bottomHtml	? '' : ' style="display:none"', '><td id="cke_bottom_'	, name, '" class="cke_bottom">'		, bottomHtml	, '</td></tr>' +
				'</tbody></table>' +
			'</span>' ].join('') );

		container.unselectable();

		if ( elementMode == CKEDITOR.ELEMENT_MODE_REPLACE )
			container.insertAfter( element );
		else
			element.append( container );

		editor._.container = container;

		editor.fireOnce( 'themeLoaded' );
		editor.fireOnce( 'uiReady' );
	},

	destroy : function( editor )
	{
		var container = editor._.container;

		if ( container )
			container.remove();

		if ( editor.elementMode == CKEDITOR.ELEMENT_MODE_REPLACE )
			editor.element.show();
	}
});

CKEDITOR.editor.prototype.getThemeSpace = function( spaceName )
{
	var spacePrefix = 'cke_' + spaceName;
	var space = this._[ spacePrefix ] ||
		( this._[ spacePrefix ] = CKEDITOR.document.getById( spacePrefix + '_' + this.name ) );
	return space;
};
