/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

importPackage( org.mozilla.javascript );

importClass( java.lang.System );
importClass( java.io.File );
importClass( java.io.BufferedWriter );
importClass( java.io.FileWriter );

var CKPACKAGER =
{
	dir : (function()
		{
			var packagerDir = new File( System.getProperty( 'java.class.path' ) );
			return packagerDir.getParent();
		})(),

	getPackPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.packDir, relativePath );
		return file.getAbsolutePath();
	},

	getPackagerPath : function( relativePath )
	{
		var file = new File( CKPACKAGER.dir, relativePath );
		return file.getAbsolutePath();
	},

	_loadedCode : {},

	loadCode : function( path )
	{
		if ( this._loadedCode[ path ] )
			return;

		load( CKPACKAGER.getPackagerPath( path ) );
	},

	tools :
	{
		readFile : function( file )
		{
			var data = readFile( file );

			// Remove the UTF-8 BOM.
			return data.replace( /^\xEF\xBB\xBF/, '' );
		},

		getFileName : function( file )
		{
			var file = new File( file );
			return file.getName();
		}
	}
};

function error( msg )
{
	print( msg );
	print( '' );
	quit();
}

if ( arguments[0] == '-dump' )
{
	CKPACKAGER.loadCode( 'includes/parser.js' );
	CKPACKAGER.parser.dumpThree( CKPACKAGER.tools.readFile( arguments[1] ) );
	quit();
}
else if ( arguments[0] == '-compress' )
{
	CKPACKAGER.loadCode( 'includes/scriptcompressor.js' );

	var compressed = CKPACKAGER.scriptCompressor.compress( CKPACKAGER.tools.readFile( arguments[1] ) );

	if ( arguments[2] )
	{
		var out = new BufferedWriter( new FileWriter( arguments[2] ) );
		out.write( compressed );
		out.close();
	}

	print( compressed );
	quit();
}
else if ( arguments[0] == '-test' )
{
	CKPACKAGER.loadCode( 'test/test.js' );
	quit();
}

CKPACKAGER.packFile = arguments[0];

if ( !CKPACKAGER.packFile )
	error( 'Usage:java -jar js.jar ckpackager.js sample.pack' );

CKPACKAGER.packDir = (function()
{
	var packFile = new File( CKPACKAGER.packFile );

	if ( !packFile.isFile() )
		error( 'The file name "' + CKPACKAGER.packFile + '" was not found.' );

	return packFile.getParent() || './';
})();

CKPACKAGER.loadCode( 'includes/packager.js' );

//for ( var o in CKPACKAGER )
//	print( o + ': ' + CKPACKAGER[o] );

// print( String( System.getProperties() ).replace( /,/g, '\n') );

(function()
{
	var packager = new CKPACKAGER.packager();
	packager.loadDefinitionFile( CKPACKAGER.packFile );
	packager.run();
})();
