/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

function GetTokenName( token )
{
    switch ( token )
    {
      case Token.ERROR:           return "ERROR";
      case Token.EOF:             return "EOF";
      case Token.EOL:             return "EOL";
      case Token.ENTERWITH:       return "ENTERWITH";
      case Token.LEAVEWITH:       return "LEAVEWITH";
      case Token.RETURN:          return "RETURN";
      case Token.GOTO:            return "GOTO";
      case Token.IFEQ:            return "IFEQ";
      case Token.IFNE:            return "IFNE";
      case Token.SETNAME:         return "SETNAME";
      case Token.BITOR:           return "BITOR";
      case Token.BITXOR:          return "BITXOR";
      case Token.BITAND:          return "BITAND";
      case Token.EQ:              return "EQ";
      case Token.NE:              return "NE";
      case Token.LT:              return "LT";
      case Token.LE:              return "LE";
      case Token.GT:              return "GT";
      case Token.GE:              return "GE";
      case Token.LSH:             return "LSH";
      case Token.RSH:             return "RSH";
      case Token.URSH:            return "URSH";
      case Token.ADD:             return "ADD";
      case Token.SUB:             return "SUB";
      case Token.MUL:             return "MUL";
      case Token.DIV:             return "DIV";
      case Token.MOD:             return "MOD";
      case Token.NOT:             return "NOT";
      case Token.BITNOT:          return "BITNOT";
      case Token.POS:             return "POS";
      case Token.NEG:             return "NEG";
      case Token.NEW:             return "NEW";
      case Token.DELPROP:         return "DELPROP";
      case Token.TYPEOF:          return "TYPEOF";
      case Token.GETPROP:         return "GETPROP";
      case Token.GETPROPNOWARN:   return "GETPROPNOWARN";
      case Token.SETPROP:         return "SETPROP";
      case Token.GETELEM:         return "GETELEM";
      case Token.SETELEM:         return "SETELEM";
      case Token.CALL:            return "CALL";
      case Token.NAME:            return "NAME";
      case Token.NUMBER:          return "NUMBER";
      case Token.STRING:          return "STRING";
      case Token.NULL:            return "NULL";
      case Token.THIS:            return "THIS";
      case Token.FALSE:           return "FALSE";
      case Token.TRUE:            return "TRUE";
      case Token.SHEQ:            return "SHEQ";
      case Token.SHNE:            return "SHNE";
      case Token.REGEXP:          return "REGEXP";
      case Token.BINDNAME:        return "BINDNAME";
      case Token.THROW:           return "THROW";
      case Token.RETHROW:         return "RETHROW";
      case Token.IN:              return "IN";
      case Token.INSTANCEOF:      return "INSTANCEOF";
      case Token.LOCAL_LOAD:      return "LOCAL_LOAD";
      case Token.GETVAR:          return "GETVAR";
      case Token.SETVAR:          return "SETVAR";
      case Token.CATCH_SCOPE:     return "CATCH_SCOPE";
      case Token.ENUM_INIT_KEYS:  return "ENUM_INIT_KEYS";
      case Token.ENUM_INIT_VALUES:return "ENUM_INIT_VALUES";
      case Token.ENUM_INIT_ARRAY: return "ENUM_INIT_ARRAY";
      case Token.ENUM_NEXT:       return "ENUM_NEXT";
      case Token.ENUM_ID:         return "ENUM_ID";
      case Token.THISFN:          return "THISFN";
      case Token.RETURN_RESULT:   return "RETURN_RESULT";
      case Token.ARRAYLIT:        return "ARRAYLIT";
      case Token.OBJECTLIT:       return "OBJECTLIT";
      case Token.GET_REF:         return "GET_REF";
      case Token.SET_REF:         return "SET_REF";
      case Token.DEL_REF:         return "DEL_REF";
      case Token.REF_CALL:        return "REF_CALL";
      case Token.REF_SPECIAL:     return "REF_SPECIAL";
      case Token.DEFAULTNAMESPACE:return "DEFAULTNAMESPACE";
      case Token.ESCXMLTEXT:      return "ESCXMLTEXT";
      case Token.ESCXMLATTR:      return "ESCXMLATTR";
      case Token.REF_MEMBER:      return "REF_MEMBER";
      case Token.REF_NS_MEMBER:   return "REF_NS_MEMBER";
      case Token.REF_NAME:        return "REF_NAME";
      case Token.REF_NS_NAME:     return "REF_NS_NAME";
      case Token.TRY:             return "TRY";
      case Token.SEMI:            return "SEMI";
      case Token.LB:              return "LB";
      case Token.RB:              return "RB";
      case Token.LC:              return "LC";
      case Token.RC:              return "RC";
      case Token.LP:              return "LP";
      case Token.RP:              return "RP";
      case Token.COMMA:           return "COMMA";
      case Token.ASSIGN:          return "ASSIGN";
      case Token.ASSIGN_BITOR:    return "ASSIGN_BITOR";
      case Token.ASSIGN_BITXOR:   return "ASSIGN_BITXOR";
      case Token.ASSIGN_BITAND:   return "ASSIGN_BITAND";
      case Token.ASSIGN_LSH:      return "ASSIGN_LSH";
      case Token.ASSIGN_RSH:      return "ASSIGN_RSH";
      case Token.ASSIGN_URSH:     return "ASSIGN_URSH";
      case Token.ASSIGN_ADD:      return "ASSIGN_ADD";
      case Token.ASSIGN_SUB:      return "ASSIGN_SUB";
      case Token.ASSIGN_MUL:      return "ASSIGN_MUL";
      case Token.ASSIGN_DIV:      return "ASSIGN_DIV";
      case Token.ASSIGN_MOD:      return "ASSIGN_MOD";
      case Token.HOOK:            return "HOOK";
      case Token.COLON:           return "COLON";
      case Token.OR:              return "OR";
      case Token.AND:             return "AND";
      case Token.INC:             return "INC";
      case Token.DEC:             return "DEC";
      case Token.DOT:             return "DOT";
      case Token.FUNCTION:        return "FUNCTION";
      case Token.EXPORT:          return "EXPORT";
      case Token.IMPORT:          return "IMPORT";
      case Token.IF:              return "IF";
      case Token.ELSE:            return "ELSE";
      case Token.SWITCH:          return "SWITCH";
      case Token.CASE:            return "CASE";
      case Token.DEFAULT:         return "DEFAULT";
      case Token.WHILE:           return "WHILE";
      case Token.DO:              return "DO";
      case Token.FOR:             return "FOR";
      case Token.BREAK:           return "BREAK";
      case Token.CONTINUE:        return "CONTINUE";
      case Token.VAR:             return "VAR";
      case Token.WITH:            return "WITH";
      case Token.CATCH:           return "CATCH";
      case Token.FINALLY:         return "FINALLY";
      case Token.VOID:            return "VOID";
      case Token.RESERVED:        return "RESERVED";
      case Token.EMPTY:           return "EMPTY";
      case Token.BLOCK:           return "BLOCK";
      case Token.LABEL:           return "LABEL";
      case Token.TARGET:          return "TARGET";
      case Token.LOOP:            return "LOOP";
      case Token.EXPR_VOID:       return "EXPR_VOID";
      case Token.EXPR_RESULT:     return "EXPR_RESULT";
      case Token.JSR:             return "JSR";
      case Token.SCRIPT:          return "SCRIPT";
      case Token.TYPEOFNAME:      return "TYPEOFNAME";
      case Token.USE_STACK:       return "USE_STACK";
      case Token.SETPROP_OP:      return "SETPROP_OP";
      case Token.SETELEM_OP:      return "SETELEM_OP";
      case Token.LOCAL_BLOCK:     return "LOCAL_BLOCK";
      case Token.SET_REF_OP:      return "SET_REF_OP";
      case Token.DOTDOT:          return "DOTDOT";
      case Token.COLONCOLON:      return "COLONCOLON";
      case Token.XML:             return "XML";
      case Token.DOTQUERY:        return "DOTQUERY";
      case Token.XMLATTR:         return "XMLATTR";
      case Token.XMLEND:          return "XMLEND";
      case Token.TO_OBJECT:       return "TO_OBJECT";
      case Token.TO_DOUBLE:       return "TO_DOUBLE";
      case Token.GET:             return "GET";
      case Token.SET:             return "SET";
      case Token.LET:             return "LET";
      case Token.YIELD:           return "YIELD";
      case Token.CONST:           return "CONST";
      case Token.SETCONST:        return "SETCONST";
      case Token.ARRAYCOMP:       return "ARRAYCOMP";
      case Token.WITHEXPR:        return "WITHEXPR";
      case Token.LETEXPR:         return "LETEXPR";
      case Token.DEBUGGER:        return "DEBUGGER";
    }

    return '??? ' + token;
}

/*
	The following tokens are not managed by the compressor.

          case ERROR:           return "ERROR";
          case EOF:             return "EOF";
          case EOL:             return "EOL";
          case GETPROPNOWARN:   return "GETPROPNOWARN";
          case RETHROW:         return "RETHROW";
          case IN:              return "IN";
          case INSTANCEOF:      return "INSTANCEOF";
          case LOCAL_LOAD:      return "LOCAL_LOAD";
          case GETVAR:          return "GETVAR";
          case SETVAR:          return "SETVAR";
          case ENUM_INIT_KEYS:  return "ENUM_INIT_KEYS";
          case ENUM_INIT_VALUES:return "ENUM_INIT_VALUES";
          case ENUM_INIT_ARRAY: return "ENUM_INIT_ARRAY";
          case ENUM_NEXT:       return "ENUM_NEXT";
          case ENUM_ID:         return "ENUM_ID";
          case THISFN:          return "THISFN";
          case RETURN_RESULT:   return "RETURN_RESULT";
          case GET_REF:         return "GET_REF";
          case SET_REF:         return "SET_REF";
          case DEL_REF:         return "DEL_REF";
          case REF_CALL:        return "REF_CALL";
          case REF_SPECIAL:     return "REF_SPECIAL";
          case DEFAULTNAMESPACE:return "DEFAULTNAMESPACE";
          case ESCXMLTEXT:      return "ESCXMLTEXT";
          case ESCXMLATTR:      return "ESCXMLATTR";
          case REF_MEMBER:      return "REF_MEMBER";
          case REF_NS_MEMBER:   return "REF_NS_MEMBER";
          case REF_NAME:        return "REF_NAME";
          case REF_NS_NAME:     return "REF_NS_NAME";
          case SEMI:            return "SEMI";
          case LB:              return "LB";
          case RB:              return "RB";
          case LC:              return "LC";
          case RC:              return "RC";
          case LP:              return "LP";
          case RP:              return "RP";
          case ASSIGN:          return "ASSIGN";
          case ASSIGN_BITOR:    return "ASSIGN_BITOR";
          case ASSIGN_BITXOR:   return "ASSIGN_BITXOR";
          case ASSIGN_BITAND:   return "ASSIGN_BITAND";
          case ASSIGN_LSH:      return "ASSIGN_LSH";
          case ASSIGN_RSH:      return "ASSIGN_RSH";
          case ASSIGN_URSH:     return "ASSIGN_URSH";
          case ASSIGN_ADD:      return "ASSIGN_ADD";
          case ASSIGN_SUB:      return "ASSIGN_SUB";
          case ASSIGN_MUL:      return "ASSIGN_MUL";
          case ASSIGN_DIV:      return "ASSIGN_DIV";
          case ASSIGN_MOD:      return "ASSIGN_MOD";
          case COLON:           return "COLON";
          case DOT:             return "DOT";
          case EXPORT:          return "EXPORT";
          case IMPORT:          return "IMPORT";
          case IF:              return "IF";
          case ELSE:            return "ELSE";
          case DEFAULT:         return "DEFAULT";
          case WHILE:           return "WHILE";
          case DO:              return "DO";
          case FOR:             return "FOR";
          case WITH:            return "WITH";
          case RESERVED:        return "RESERVED";
          case EMPTY:           return "EMPTY";
          case LABEL:           return "LABEL";
          case JSR:             return "JSR";
          case USE_STACK:       return "USE_STACK";
          case SETPROP_OP:      return "SETPROP_OP";
          case SETELEM_OP:      return "SETELEM_OP";
          case LOCAL_BLOCK:     return "LOCAL_BLOCK";
          case SET_REF_OP:      return "SET_REF_OP";
          case DOTDOT:          return "DOTDOT";
          case COLONCOLON:      return "COLONCOLON";
          case XML:             return "XML";
          case DOTQUERY:        return "DOTQUERY";
          case XMLATTR:         return "XMLATTR";
          case XMLEND:          return "XMLEND";
          case TO_OBJECT:       return "TO_OBJECT";
          case TO_DOUBLE:       return "TO_DOUBLE";
          case GET:             return "GET";
          case SET:             return "SET";
          case LET:             return "LET";
          case YIELD:           return "YIELD";
          case CONST:           return "CONST";
          case SETCONST:        return "SETCONST";
          case ARRAYCOMP:       return "ARRAYCOMP";
          case WITHEXPR:        return "WITHEXPR";
          case LETEXPR:         return "LETEXPR";
          case DEBUGGER:        return "DEBUGGER";
*/
