/*
Copyright (c) 2003-2008, Frederico Caldeira Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

importClass( java.io.BufferedWriter );
importClass( java.io.FileWriter );

CKPACKAGER.loadCode( 'includes/scriptcompressor.js' );

CKPACKAGER.packageFile = function( outputFile )
{
	this.output = outputFile;

	this.header = null;
	this.noCheck = false;
	this.constants = null;
	this.renameGlobals = false;
	this.compactJavascript = true;
	this.wrap = false;
	this.files = [];
};

CKPACKAGER.packageFile.prototype =
{
	createFile : function()
	{
		var source = [];

		print( 'Packaging file ' + CKPACKAGER.tools.getFileName( this.output ) + '\n' );

		for ( var i = 0 ; i < this.files.length ; i++ )
		{
			var file = this.files[ i ];

			print( '    Adding ' + CKPACKAGER.tools.getFileName( file ) );

			source.push( CKPACKAGER.tools.readFile( file ), '\n' );
		}

		source = source.join( '' );

		var compressed = this.compactJavascript ?
			CKPACKAGER.scriptCompressor.compress( source, this.renameGlobals, this.constants, this.noCheck, this.wrap ) :
			source;

		if ( this.header )
			compressed = this.header + compressed;

		compressed += '\n';

		try
		{
			var file = new File( this.output );
			file['delete']();

			var out = new BufferedWriter( new FileWriter( this.output ) );
			out.write( compressed );
			out.close();
	    }
	    catch ( e )
	    {
			throw e;
	    }

		print( '' );
		print( '    Number of files processed: ' + this.files.length );
		print( '    Original size............: ' + source.length + ' bytes' );
		print( '    Output file size.........: ' + compressed.length + ' bytes (' + Math.round( compressed.length / source.length * 100 ) + '% of original)' );
		print( '' );
	}
};
